/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javajs.util.PT;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;

public class GaussianDialog
extends JDialog
implements ActionListener,
ChangeListener,
MouseListener {
    Viewer vwr;
    private JPanel container;
    private JTextField checkField;
    private JTextField optsField;
    private JTextField fileField;
    private JTextField selectField;
    private JComboBox<String> memBox;
    private JComboBox<String> methBox;
    private JComboBox<String> basisBox;
    private JComboBox<String> dfBox;
    private JSpinner procSpinner;
    private JSpinner chargeSpinner;
    private JSpinner multSpinner;
    private JButton fileButton;
    private JButton saveButton;
    private JButton closeButton;
    private JButton refreshButton;
    private JFileChooser fileChooser;
    protected JTextPane editArea;
    private String check;
    private String mem;
    private String proc;
    private String file;
    private String meth;
    private String route;
    private String charge;
    private String mult;
    private String select;
    protected JScrollPane editPane;
    protected int iscroll;
    private static final String DEFAULT_METHOD = "HF";
    private static final String DEFAULT_BASIS = "3-21G**";
    private static final String DEFAULT_CHARGE = "0";
    private static final String DEFAULT_MULT = "1";
    private static final String[] BASIS_LIST = new String[]{"Gen", "3-21G", "3-21G*", "3-21G**", "6-21G", "4-31G", "6-31G", "6-311G", "D95V", "D95", "SHC", "CEP-4G", "CEP-31G", "CEP-121G", "LanL2MB", "LanL2DZ", "SDD", "SDDAll", "cc-pVDZ", "cc-pVTZ", "cc-pVQZ", "cc-pV5Z", "cc-pV6Z", "aug-cc-pVDZ", "aug-cc-pVTZ", "aug-cc-pVQZ", "aug-cc-pV5Z", "aug-cc-pV6Z", "SV", "SVP", "TZV", "TZVP", "MidiX", "EPR-II", "EPR-III", "UGBS", "UGBS1P", "UGBS2P", "UGBS3P", "MTSmall", "DGDZVP", "DGDZVP2", "DGTZVP"};
    private static final String[] METHOD_LIST = new String[]{"HF", "MP2", "MP3", "MP4", "CCSD(T)", "CIS", "CISD", "LSDA", "BLYP", "BP86", "BPW91", "OLYP", "OP86", "OPW91", "PBEPBE", "VSXC", "HCTH93", "HCTH147", "HCTH407", "TPSSTPSS", "B3LYP", "B3PW91", "AM1", "PM3", "CNDO", "INDO", "MNDO", "MINDO3", "ZINDO", "UFF", "AMBER", "DREIDING", "Huckel"};
    private static final String[] DF_LIST = new String[]{"None", "Auto", "DGA1", "DGA2"};
    private static final String[] MEMORY_LIST = new String[]{"Default", "100MB", "500MB", "1GB", "2GB", "4GB", "7GB", "15GB"};
    private static final String NOBASIS_LIST = "AM1 PM3 CNDO INDO MNDO MINDO3 ZINDO UFF AMBER DREIDING Huckel";
    private static final String DFT_LIST = "LSDA BLYP BP86 BPW91 OLYP OP86 OPW91 PBEPBE VSXC HCTH93 NCTH147 HCTH407 TPSSTPSS B3LYP B3PW91";

    public GaussianDialog(JFrame f, Viewer vwr) {
        super((Frame)f, false);
        this.vwr = vwr;
        this.setTitle(GT.$("Create Gaussian Input File"));
        this.container = new JPanel();
        this.container.setLayout(new BorderLayout());
        JPanel basicPanel = this.buildBasicPanel();
        JPanel advancedPanel = this.buildAdvancedPanel();
        JPanel filePanel = this.buildFilePanel();
        JPanel buttonPanel = this.buildButtonPanel();
        JSplitPane splitPane = new JSplitPane(1, basicPanel, advancedPanel);
        this.container.add((Component)splitPane, "North");
        this.container.add((Component)filePanel, "Center");
        this.container.add((Component)buttonPanel, "South");
        this.getContentPane().add(this.container);
        this.pack();
        this.centerDialog();
        this.updateUI();
    }

    private JPanel buildBasicPanel() {
        JPanel showPanel = new JPanel(new BorderLayout());
        JPanel linkPanel = new JPanel(new BorderLayout());
        TitledBorder linkTitle = BorderFactory.createTitledBorder("link0 Section");
        linkPanel.setBorder(linkTitle);
        JPanel linkLabels = new JPanel(new GridLayout(3, 1));
        JPanel linkControls = new JPanel(new GridLayout(3, 1));
        JLabel checkLabel = new JLabel(GT.$("Checkpoint File: "));
        linkLabels.add(checkLabel);
        this.checkField = new JTextField(20);
        linkControls.add(this.checkField);
        this.checkField.addActionListener(this);
        JLabel memLabel = new JLabel(GT.$("Memory:"));
        linkLabels.add(memLabel);
        this.memBox = new JComboBox<String>(MEMORY_LIST);
        linkControls.add(this.memBox);
        this.memBox.setSelectedIndex(0);
        this.memBox.addActionListener(this);
        JLabel procLabel = new JLabel(GT.$("Processors:"));
        linkLabels.add(procLabel);
        SpinnerNumberModel procModel = new SpinnerNumberModel(1, 1, 16, 1);
        this.procSpinner = new JSpinner(procModel);
        this.procSpinner.setEditor(new JSpinner.NumberEditor(this.procSpinner, "#"));
        linkControls.add(this.procSpinner);
        this.procSpinner.addChangeListener(this);
        linkPanel.add((Component)linkLabels, "Before");
        linkPanel.add((Component)linkControls, "Center");
        showPanel.add((Component)linkPanel, "North");
        JPanel routePanel = new JPanel(new BorderLayout());
        TitledBorder routeTitle = BorderFactory.createTitledBorder(GT.$("Route"));
        routePanel.setBorder(routeTitle);
        JPanel routeLabels = new JPanel(new GridLayout(4, 1));
        JPanel routeControls = new JPanel(new GridLayout(4, 1));
        JLabel methLabel = new JLabel(GT.$("Method: "));
        routeLabels.add(methLabel);
        this.methBox = new JComboBox<String>(METHOD_LIST);
        routeControls.add(this.methBox);
        this.methBox.setSelectedIndex(0);
        this.methBox.addActionListener(this);
        JLabel basisLabel = new JLabel(GT.$("Basis Set: "));
        routeLabels.add(basisLabel);
        this.basisBox = new JComboBox<String>(BASIS_LIST);
        routeControls.add(this.basisBox);
        this.basisBox.setSelectedIndex(3);
        this.basisBox.addActionListener(this);
        JLabel dfLabel = new JLabel(GT.$("DFT Density Fit: "));
        routeLabels.add(dfLabel);
        this.dfBox = new JComboBox<String>(DF_LIST);
        routeControls.add(this.dfBox);
        this.dfBox.setSelectedIndex(0);
        this.dfBox.addActionListener(this);
        JLabel optsLabel = new JLabel(GT.$("Job Options: "));
        routeLabels.add(optsLabel);
        this.optsField = new JTextField(20);
        routeControls.add(this.optsField);
        this.optsField.setText("opt pop=full gfprint");
        this.optsField.addActionListener(this);
        routePanel.add((Component)routeLabels, "Before");
        routePanel.add((Component)routeControls, "Center");
        showPanel.add((Component)routePanel, "Center");
        JPanel molPanel = new JPanel(new BorderLayout());
        TitledBorder molTitle = BorderFactory.createTitledBorder(GT.$("Molecular Properties"));
        molPanel.setBorder(molTitle);
        JPanel molLabels = new JPanel(new GridLayout(3, 1));
        JPanel molControls = new JPanel(new GridLayout(3, 1));
        JLabel chargeLabel = new JLabel(GT.$("Total Charge: "));
        molLabels.add(chargeLabel);
        SpinnerNumberModel chargeModel = new SpinnerNumberModel(0, -10, 10, 1);
        this.chargeSpinner = new JSpinner(chargeModel);
        this.chargeSpinner.setEditor(new JSpinner.NumberEditor(this.chargeSpinner, "#"));
        molControls.add(this.chargeSpinner);
        this.chargeSpinner.addChangeListener(this);
        JLabel multLabel = new JLabel(GT.$("Multiplicity: "));
        molLabels.add(multLabel);
        SpinnerNumberModel multModel = new SpinnerNumberModel(1, 0, 10, 1);
        this.multSpinner = new JSpinner(multModel);
        this.multSpinner.setEditor(new JSpinner.NumberEditor(this.multSpinner, "#"));
        molControls.add(this.multSpinner);
        this.multSpinner.addChangeListener(this);
        molPanel.add((Component)molLabels, "Before");
        molPanel.add((Component)molControls, "Center");
        showPanel.add((Component)molPanel, "South");
        return showPanel;
    }

    private JPanel buildAdvancedPanel() {
        JPanel editPanel = new JPanel(new BorderLayout());
        TitledBorder editTitle = BorderFactory.createTitledBorder("Edit Gaussian Input File");
        editPanel.setBorder(editTitle);
        this.editArea = new JTextPane();
        this.editArea.setContentType("text/html");
        this.editArea.setFont(new Font("Monospaced", 0, 8));
        this.editArea.addMouseListener(this);
        this.editPane = new JScrollPane(this.editArea);
        this.editPane.setPreferredSize(new Dimension(150, 100));
        editPanel.add((Component)this.editPane, "Center");
        return editPanel;
    }

    private JPanel buildFilePanel() {
        JPanel showPanel = new JPanel(new FlowLayout(2));
        TitledBorder fileTitle = BorderFactory.createTitledBorder(GT.$("Gaussian Input File Name"));
        showPanel.setBorder(fileTitle);
        this.fileField = new JTextField(30);
        showPanel.add(this.fileField);
        this.fileField.setText(new File("my_input.com").getAbsolutePath());
        this.fileButton = new JButton(GT.$("File..."));
        this.fileButton.addActionListener(this);
        showPanel.add(this.fileButton);
        return showPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JLabel selectLabel = new JLabel(GT.$("Selection: "));
        buttonPanel.add(selectLabel);
        this.selectField = new JTextField(20);
        this.selectField.setText("visible");
        buttonPanel.add(this.selectField);
        this.selectField.addActionListener(this);
        this.refreshButton = new JButton(GT.$("Refresh"));
        this.refreshButton.addActionListener(this);
        buttonPanel.add(this.refreshButton);
        this.saveButton = new JButton(GT.$("Save"));
        this.saveButton.addActionListener(this);
        buttonPanel.add(this.saveButton);
        this.closeButton = new JButton(GT.$("Close"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.saveButton);
        return buttonPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    private void updateVars() {
        String basis;
        this.check = this.checkField.getText();
        this.mem = this.memBox.getSelectedItem().toString();
        this.proc = this.procSpinner.getValue().toString();
        this.select = this.selectField.getText();
        if (this.select.length() == 0) {
            this.select = "visible";
            this.selectField.setText(this.select);
        }
        this.charge = this.chargeSpinner.getValue().toString();
        if (this.charge.equals("")) {
            this.charge = DEFAULT_CHARGE;
        }
        this.mult = this.multSpinner.getValue().toString();
        if (this.mult.equals("")) {
            this.mult = DEFAULT_MULT;
        }
        if ((basis = (String)this.basisBox.getSelectedItem()).equals("")) {
            basis = DEFAULT_BASIS;
        }
        this.meth = this.methBox.getSelectedItem().toString();
        if (this.meth.equals("")) {
            this.meth = DEFAULT_METHOD;
        }
        if (NOBASIS_LIST.lastIndexOf(this.meth, NOBASIS_LIST.length()) >= 0) {
            basis = "";
        }
        if (!basis.equals("")) {
            basis = "/" + basis;
        }
        String df = this.dfBox.getSelectedItem().toString();
        if (DFT_LIST.lastIndexOf(this.meth, DFT_LIST.length()) < 0) {
            df = "None";
        }
        df = df.equals("None") ? "" : "/" + df;
        this.file = this.fileField.getText();
        if (this.file.equals("")) {
            this.file = "my_input.com";
        }
        String opts = this.optsField.getText();
        this.route = "# " + this.meth + basis + df + " " + opts;
    }

    private void updateUI() {
        this.updateVars();
        if (NOBASIS_LIST.lastIndexOf(this.meth, NOBASIS_LIST.length()) >= 0) {
            this.basisBox.setEnabled(false);
        } else {
            this.basisBox.setEnabled(true);
        }
        if (DFT_LIST.lastIndexOf(this.meth, DFT_LIST.length()) >= 0) {
            this.dfBox.setEnabled(true);
        } else {
            this.dfBox.setEnabled(false);
        }
        this.getCommand(-2, true);
    }

    private void save() {
        BufferedWriter output = null;
        try {
            String s = this.editArea.getText();
            if (s.indexOf("<pre>") < 0) {
                this.getCommand(-1, true);
                s = this.editArea.getText();
            }
            File outputFile = new File(this.fileField.getText());
            this.fileField.setText(outputFile.getAbsolutePath());
            output = new BufferedWriter(new FileWriter(outputFile));
            output.write(this.asHTML(s, false));
            ((Writer)output).close();
        }
        catch (Exception err) {
            return;
        }
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.vwr.script("select off");
        super.dispose();
    }

    private void setFile() {
        this.fileChooser = new JFileChooser();
        String fname = this.fileField.getText();
        this.fileChooser.setSelectedFile(new File(fname));
        int ierr = this.fileChooser.showDialog(this, "Set");
        if (ierr == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.fileField.setText(file.getAbsolutePath());
        }
    }

    protected void getCommand(int iAtom, boolean doScroll) {
        String m;
        this.updateVars();
        String c = this.check;
        if (!c.equals("")) {
            c = "%chk=" + c + "\n";
        }
        m = !(m = this.mem).equals("Default") ? "%mem=" + m + "\n" : "";
        String p = this.proc;
        p = !p.equals(DEFAULT_MULT) ? "%nproc=" + p + "\n" : "";
        String format = "USER:%-2e %10.5x %10.5y %10.5z";
        String data = this.vwr.getData(this.select, format);
        this.iscroll = 0;
        if (iAtom >= 0) {
            String a = this.vwr.getData("atomIndex=" + iAtom, format);
            this.iscroll = data.indexOf(a);
            if (this.iscroll >= 0) {
                data = PT.rep(data, a, "<b><font color=\"red\">" + PT.rep(a, "\n", "") + "&#160;&#160;&lt;&lt;&lt;</font></b>\n");
            }
            int mm = this.editPane.getVerticalScrollBar().getMaximum();
            this.iscroll = (int)((double)this.iscroll * 1.0 / (double)data.length() * (double)mm);
        } else if (iAtom == -1) {
            this.iscroll = -1;
        }
        if (!doScroll) {
            this.iscroll = this.editPane.getVerticalScrollBar().getValue();
        }
        this.editArea.setText(this.asHTML(c + m + p + this.route + "\n\nTitle: <b>Created by Jmol</b> version " + Viewer.getJmolVersion() + "\n\n" + this.charge + " " + this.mult + "\n" + data + "\n", true));
        if (this.iscroll >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        GaussianDialog.this.editPane.getVerticalScrollBar().setValue(GaussianDialog.this.iscroll);
                    }
                    catch (Exception e) {
                        GaussianDialog.this.editPane.getVerticalScrollBar().setValue(0);
                    }
                }
            });
        }
    }

    protected String asHTML(String s, boolean toHTML) {
        if (toHTML) {
            return "<html><small><pre>" + s + "</pre></small></html>";
        }
        if (s.indexOf("<pre>") >= 0) {
            s = PT.rep(s, "<b>", "");
            s = PT.rep(s, "</b>", "");
            s = PT.rep(s, "<font color=\"red\">", "");
            s = PT.rep(s, "</font>", "");
            s = PT.rep(s, "&lt;", "");
            s = PT.rep(s, "&#160;", "");
            s = PT.split(s, "<pre>")[1];
            s = PT.split(s, "</pre>")[0];
        }
        return s.trim() + "\n";
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object c = event.getSource();
        if (c == this.saveButton) {
            this.save();
        } else if (c == this.closeButton) {
            this.cancel();
        } else if (c == this.fileButton) {
            this.setFile();
        } else if (c == this.refreshButton) {
            this.getCommand(-2, true);
        } else {
            this.updateUI();
        }
    }

    public void updateModel(int iAtom) {
        this.getCommand(iAtom, true);
        if (iAtom >= 0) {
            this.vwr.script("select on atomindex=" + iAtom);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.getCommand(-2, true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.editArea) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String s = GaussianDialog.this.asHTML(GaussianDialog.this.editArea.getText(), false);
                        int pt = GaussianDialog.this.editArea.getCaretPosition();
                        int i0 = s.lastIndexOf("\n", pt) + 5;
                        int i1 = s.indexOf("\n", pt);
                        String coord = s.substring(i0, i1);
                        if (Float.isNaN(PT.parseFloat(coord))) {
                            return;
                        }
                        GaussianDialog.this.vwr.scriptWait("select on within(0.1,{" + coord + "})");
                        GaussianDialog.this.getCommand(GaussianDialog.this.vwr.bsA().nextSetBit(0), false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

