/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openscience.jmol.app.janocchio.NMR_Viewer;

public class FrameCounter
extends JPanel {
    NMR_Viewer viewer;
    int frameNumber;
    int frameCount;
    JLabel label;
    JTextField field;

    public FrameCounter(NMR_Viewer viewer) {
        this.viewer = viewer;
        this.setLayout(new BorderLayout());
        this.label = new JLabel();
        this.label.setText(this.getLabelText());
        this.field = new JTextField(5);
        this.field.setText(String.valueOf(this.getFrameNumber()));
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameCounter.this.fieldActionPerformed(evt);
            }
        });
        this.add((Component)this.label, "West");
        this.add((Component)this.field, "Center");
    }

    private void fieldActionPerformed(ActionEvent evt) {
        int number = Integer.parseInt(this.field.getText());
        this.setFrameNumberChangeViewer(number);
    }

    public void setFrameNumberChangeViewer(int number) {
        this.frameNumber = number;
        String command = new String("frame ");
        command = command + String.valueOf(number);
        this.viewer.script(command);
    }

    public void setFrameNumberFromViewer(int number) {
        this.frameNumber = number;
        this.field.setText(String.valueOf(number));
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public void setFrameCount(int number) {
        this.frameCount = number;
        this.label.setText(this.getLabelText());
    }

    private String getLabelText() {
        String text = " Frame [" + String.valueOf(this.frameCount) + " total] :";
        return text;
    }
}

