/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javajs.J2SIgnoreImport;
import javajs.api.BytePoster;
import javajs.api.GenericOutputChannel;
import javajs.api.js.J2SObjectInterface;
import javajs.util.Base64;
import javajs.util.SB;

@J2SIgnoreImport(value={FileOutputStream.class})
public class OC
extends OutputStream
implements GenericOutputChannel {
    private BytePoster bytePoster;
    private String fileName;
    private BufferedWriter bw;
    private boolean isLocalFile;
    private int byteCount;
    private boolean isCanceled;
    private boolean closed;
    private OutputStream os;
    private SB sb;
    private String type;
    private boolean isBase64;
    private OutputStream os0;
    private byte[] bytes;
    public boolean bigEndian = true;
    public static final String[] urlPrefixes = new String[]{"http:", "https:", "sftp:", "ftp:", "file:", "cache:"};
    public static final int URL_LOCAL = 4;
    public static final int URL_CACHE = 5;

    public OC() {
    }

    public OC(String string) {
        this.setParams(null, string, false, null);
    }

    public OC setParams(BytePoster bytePoster, String string, boolean bl, OutputStream outputStream) {
        this.bytePoster = bytePoster;
        this.isBase64 = ";base64,".equals(string);
        if (this.isBase64) {
            string = null;
            this.os0 = outputStream;
            outputStream = null;
        }
        this.fileName = string;
        this.os = outputStream;
        boolean bl2 = this.isLocalFile = string != null && !OC.isRemote(string);
        if (bl && !this.isBase64 && outputStream != null) {
            this.bw = new BufferedWriter(new OutputStreamWriter(outputStream));
        }
        return this;
    }

    @Override
    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(boolean bl) {
        this.bigEndian = bl;
    }

    public OC setBytes(byte[] byArray) {
        this.bytes = byArray;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.fileName == null ? null : this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public OC append(String string) {
        block5: {
            try {
                if (this.bw != null) {
                    this.bw.write(string);
                    break block5;
                }
                if (this.os == null) {
                    if (this.sb == null) {
                        this.sb = new SB();
                    }
                    this.sb.append(string);
                    break block5;
                }
                byte[] byArray = string.getBytes();
                this.os.write(byArray, 0, byArray.length);
                this.byteCount += byArray.length;
                return this;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.byteCount += string.length();
        return this;
    }

    @Override
    public void reset() {
        this.sb = null;
        this.initOS();
    }

    private void initOS() {
        if (this.sb != null) {
            String string = this.sb.toString();
            this.reset();
            this.append(string);
            return;
        }
        try {
            if (this.os instanceof FileOutputStream) {
                this.os.close();
                this.os = new FileOutputStream(this.fileName);
            } else {
                this.os = null;
            }
            if (this.os == null) {
                this.os = new ByteArrayOutputStream();
            }
            if (this.bw != null) {
                this.bw.close();
                this.bw = new BufferedWriter(new OutputStreamWriter(this.os));
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.byteCount = 0;
    }

    @Override
    public void writeByteAsInt(int n) {
        if (this.os == null) {
            this.initOS();
        }
        try {
            this.os.write(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.byteCount;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (this.os == null) {
            this.initOS();
        }
        if (n2 < 0) {
            n2 = byArray.length - n;
        }
        try {
            this.os.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.byteCount += n2;
    }

    @Override
    public void writeShort(short s) {
        if (this.isBigEndian()) {
            this.writeByteAsInt(s >> 8);
            this.writeByteAsInt(s);
        } else {
            this.writeByteAsInt(s);
            this.writeByteAsInt(s >> 8);
        }
    }

    @Override
    public void writeLong(long l) {
        if (this.isBigEndian()) {
            this.writeInt((int)(l >> 32 & 0xFFFFFFFFL));
            this.writeInt((int)(l & 0xFFFFFFFFL));
        } else {
            this.writeByteAsInt((int)(l >> 56));
            this.writeByteAsInt((int)(l >> 48));
            this.writeByteAsInt((int)(l >> 40));
            this.writeByteAsInt((int)(l >> 32));
            this.writeByteAsInt((int)(l >> 24));
            this.writeByteAsInt((int)(l >> 16));
            this.writeByteAsInt((int)(l >> 8));
            this.writeByteAsInt((int)l);
        }
    }

    @Override
    @Deprecated
    public void write(int n) {
        if (this.os == null) {
            this.initOS();
        }
        try {
            this.os.write(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.byteCount;
    }

    public void cancel() {
        this.isCanceled = true;
        this.closeChannel();
    }

    @Override
    public String closeChannel() {
        if (this.closed) {
            return null;
        }
        try {
            if (this.bw != null) {
                this.bw.flush();
                this.bw.close();
            } else if (this.os != null) {
                this.os.flush();
                this.os.close();
            }
            if (this.os0 != null && this.isCanceled) {
                this.os0.flush();
                this.os0.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isCanceled) {
            this.closed = true;
            return null;
        }
        if (this.fileName == null) {
            if (this.isBase64) {
                String string = this.getBase64();
                if (this.os0 != null) {
                    this.os = this.os0;
                    this.append(string);
                }
                this.sb = new SB();
                this.sb.append(string);
                this.isBase64 = false;
                return this.closeChannel();
            }
            return this.sb == null ? null : this.sb.toString();
        }
        this.closed = true;
        if (!this.isLocalFile) {
            String string = this.postByteArray();
            if (string == null || string.startsWith("java.net")) {
                this.byteCount = -1;
            }
            return string;
        }
        J2SObjectInterface j2SObjectInterface = null;
        Object var2_5 = null;
        if (j2SObjectInterface != null) {
            Object object;
            Object object2 = object = this.sb == null ? this.toByteArray() : (Object)this.sb.toString();
            if (var2_5 == null) {
                j2SObjectInterface.doAjax((Object)this.fileName, null, object, this.sb == null);
            } else {
                j2SObjectInterface.applyFunc(this.fileName, object);
            }
        }
        return null;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public String getBase64() {
        return Base64.getBase64(this.toByteArray()).toString();
    }

    public byte[] toByteArray() {
        return this.bytes != null ? this.bytes : (byte[])(this.os instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)this.os).toByteArray() : null);
    }

    @Override
    @Deprecated
    public void close() {
        this.closeChannel();
    }

    public String toString() {
        if (this.bw != null) {
            try {
                this.bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.sb != null) {
            return this.closeChannel();
        }
        return String.valueOf(this.byteCount) + " bytes";
    }

    private String postByteArray() {
        byte[] byArray = this.sb == null ? this.toByteArray() : this.sb.toString().getBytes();
        return this.bytePoster.postByteArray(this.fileName, byArray);
    }

    public static boolean isRemote(String string) {
        if (string == null) {
            return false;
        }
        int n = OC.urlTypeIndex(string);
        return n >= 0 && n < 4;
    }

    public static boolean isLocal(String string) {
        return string != null && !OC.isRemote(string);
    }

    public static int urlTypeIndex(String string) {
        if (string == null) {
            return -2;
        }
        int n = 0;
        while (n < urlPrefixes.length) {
            if (string.startsWith(urlPrefixes[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void writeInt(int n) {
        if (this.bigEndian) {
            this.writeByteAsInt(n >> 24);
            this.writeByteAsInt(n >> 16);
            this.writeByteAsInt(n >> 8);
            this.writeByteAsInt(n);
        } else {
            this.writeByteAsInt(n);
            this.writeByteAsInt(n >> 8);
            this.writeByteAsInt(n >> 16);
            this.writeByteAsInt(n >> 24);
        }
    }

    public void writeFloat(float f) {
        this.writeInt(f == 0.0f ? 0 : Float.floatToIntBits(f));
    }
}

