/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;

final class CharBuffer {
    public char[] cs;
    public int position;

    private CharBuffer(char[] cs) {
        this.cs = cs;
    }

    boolean hasRemaining() {
        return this.position < this.cs.length;
    }

    int position() {
        return this.position;
    }

    char get() {
        return this.cs[this.position++];
    }

    char next() {
        return this.cs[this.position];
    }

    boolean nextIsDigit() {
        return this.hasRemaining() && CharBuffer.isDigit(this.next());
    }

    int getAsDigit() {
        return CharBuffer.toDigit(this.get());
    }

    int nextAsDigit() {
        return CharBuffer.toDigit(this.next());
    }

    boolean nextIs(char c) {
        return this.hasRemaining() && this.cs[this.position] == c;
    }

    boolean getIf(char c) {
        if (this.hasRemaining() && this.nextIs(c)) {
            ++this.position;
            return true;
        }
        return false;
    }

    int getNumber() {
        if (!this.nextIsDigit()) {
            return -1;
        }
        int num = this.getAsDigit();
        while (this.nextIsDigit()) {
            num = num * 10 + this.getAsDigit();
        }
        return num;
    }

    int getNumber(int nDigits) {
        if (!this.nextIsDigit()) {
            return -1;
        }
        int num = this.getAsDigit();
        while (--nDigits > 0 && this.nextIsDigit()) {
            num = num * 10 + this.getAsDigit();
        }
        return num;
    }

    String substr(int from, int to) {
        return new String(Arrays.copyOfRange(this.cs, from, to));
    }

    int length() {
        return this.cs.length;
    }

    static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static int toDigit(char c) {
        return c - 48;
    }

    static CharBuffer fromString(String str) {
        return new CharBuffer(str.toCharArray());
    }

    public String toString() {
        return new String(this.cs);
    }
}

