/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnarinchi.cheminfo;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiInput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MoleculeUtils {
    public static boolean containsHydrogen(List<InchiAtom> atoms) {
        for (InchiAtom a : atoms) {
            if (!a.getElName().equals("H")) continue;
            return true;
        }
        return false;
    }

    public static void setImplicitHydrogenAtoms(InchiInput inchiInput) {
        Map<InchiAtom, Integer> atomExplVal = MoleculeUtils.getExplicitAtomValencies(inchiInput);
        for (InchiAtom at : inchiInput.getAtoms()) {
            int maxImplHydrogen;
            Integer explVal = atomExplVal.get(at);
            if (explVal == null) {
                explVal = 0;
            }
            if ((maxImplHydrogen = MoleculeUtils.getImplicitHAtomsCount(at.getElName(), at.getCharge(), explVal)) < explVal) continue;
            at.setImplicitHydrogen(maxImplHydrogen - explVal);
        }
    }

    public static Map<InchiAtom, Integer> getExplicitAtomValencies(InchiInput inchiInput) {
        HashMap<InchiAtom, Integer> atomVal = new HashMap<InchiAtom, Integer>();
        for (InchiBond bo : inchiInput.getBonds()) {
            Integer val = (Integer)atomVal.get(bo.getStart());
            val = val == null ? Integer.valueOf(MoleculeUtils.getOrder(bo.getType())) : Integer.valueOf(val + MoleculeUtils.getOrder(bo.getType()));
            atomVal.put(bo.getStart(), val);
            val = (Integer)atomVal.get(bo.getEnd());
            val = val == null ? Integer.valueOf(MoleculeUtils.getOrder(bo.getType())) : Integer.valueOf(val + MoleculeUtils.getOrder(bo.getType()));
            atomVal.put(bo.getEnd(), val);
        }
        return atomVal;
    }

    public static int getOrder(InchiBondType ibt) {
        switch (ibt) {
            case NONE: {
                return 0;
            }
            case SINGLE: {
                return 1;
            }
            case DOUBLE: {
                return 2;
            }
            case TRIPLE: {
                return 3;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getImplicitHAtomsCount(String elName, int charge, int val) {
        switch (elName) {
            case "H": 
            case "Li": 
            case "Na": 
            case "K": 
            case "Rb": 
            case "Cs": 
            case "Fr": {
                if (charge != 0 || val > 1) return val;
                return 1;
            }
            case "Be": 
            case "Mg": 
            case "Ca": 
            case "Sr": 
            case "Ba": 
            case "Ra": {
                switch (charge) {
                    case 0: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 1: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "B": {
                switch (charge) {
                    case -4: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case -3: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 1: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 2: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "C": {
                switch (charge) {
                    case -3: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case -2: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case -1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 0: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 1: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 2: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 3: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "N": {
                switch (charge) {
                    case -2: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case -1: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 0: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 2: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 3: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 4: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "O": {
                switch (charge) {
                    case -1: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case 0: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 2: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 3: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 4: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 5: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "F": {
                switch (charge) {
                    case 0: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case 1: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 3: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 4: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 5: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 6: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Al": {
                switch (charge) {
                    case -4: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 1: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 2: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Si": {
                switch (charge) {
                    case -3: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -2: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 0: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 1: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 2: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 3: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "P": {
                switch (charge) {
                    case -2: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 0: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 2: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 3: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 4: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "S": {
                switch (charge) {
                    case -1: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 0: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 2: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 3: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 4: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 5: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Cl": {
                switch (charge) {
                    case 0: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 3: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 4: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 5: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 6: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Ga": {
                switch (charge) {
                    case -4: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 2: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Ge": {
                switch (charge) {
                    case -3: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -2: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 0: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 1: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 3: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "As": {
                switch (charge) {
                    case -2: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 0: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 2: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 4: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Se": {
                switch (charge) {
                    case -1: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 0: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 2: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 3: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 5: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Br": {
                switch (charge) {
                    case 0: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 3: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 4: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 6: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "In": {
                switch (charge) {
                    case -4: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 2: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Sn": 
            case "Pb": {
                switch (charge) {
                    case -3: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -2: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 0: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 1: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 3: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Sb": 
            case "Bi": {
                switch (charge) {
                    case -2: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 0: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 2: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 4: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Te": 
            case "Po": {
                switch (charge) {
                    case -1: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 0: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 2: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 3: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 5: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "I": 
            case "At": {
                switch (charge) {
                    case 0: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 4: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 6: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case "Tl": {
                switch (charge) {
                    case -4: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val > 3) return val;
                        return 3;
                    }
                }
            }
        }
        return val;
    }
}

