/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericColor;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;

public class CU {
    private static final String[] colorNames = new String[]{"contrast", "black", "pewhite", "pecyan", "pepurple", "pegreen", "peblue", "peviolet", "pebrown", "pepink", "peyellow", "pedarkgreen", "peorange", "pelightblue", "pedarkcyan", "pedarkgray", "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightgray", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen", "bluetint", "greenblue", "greentint", "grey", "gray", "pinktint", "redorange", "yellowtint"};
    private static final int[] colorArgbs = new int[]{-74566, -16777216, -1, -16711681, -3137281, -16711936, -10460929, -32576, -6021080, -10024, -256, -16728064, -20480, -5197569, -16736096, -10461088, -984833, -332841, -16711681, -8388652, -983041, -657956, -6972, -5171, -16776961, -7722014, -5952982, -2180985, -10510688, -8388864, -2987746, -32944, -10185235, -1828, -2354116, -16711681, -16777077, -16741493, -4684277, -5658199, -16751616, -4343957, -7667573, -11179217, -29696, -6737204, -7667712, -1468806, -7357297, -12042869, -13676721, -16724271, -7077677, -60269, -16728065, -9868951, -14774017, -5103070, -1296, -14513374, -65281, -2302756, -460545, -10496, -2448096, -8355712, -16744448, -5374161, -983056, -38476, -3318692, -11861886, -16, -989556, -1644806, -3851, -8586240, -1331, -5383962, -1015680, -2031617, -329006, -7278960, -2894893, -2894893, -18751, -24454, -14634326, -7876870, -8943463, -5192482, -32, -16711936, -13447886, -331546, -65281, -8388608, -10039894, -16777011, -4565549, -7114533, -12799119, -8689426, -16713062, -12004916, -3730043, -15132304, -655366, -6943, -6987, -8531, -16777088, -133658, -8355840, -9728477, -23296, -47872, -2461482, -1120086, -6751336, -5247250, -2396013, -4139, -9543, -3308225, -16181, -2252579, -5185306, -8388480, -65536, -4419697, -12490271, -7650029, -360334, -744352, -13726889, -2578, -6270419, -4144960, -7876885, -9807155, -9404272, -1286, -16711809, -12156236, -2968436, -16744320, -2572328, -40121, -12525360, -1146130, -663885, -1, -657931, -256, -6632142, -5253121, -13726889, -6750285, -8355712, -8355712, -21573, -47872, -592267};
    private static final Map<String, Integer> mapJavaScriptColors = new Hashtable<String, Integer>();

    static {
        int n = colorNames.length;
        while (--n >= 0) {
            mapJavaScriptColors.put(colorNames[n], colorArgbs[n]);
        }
    }

    public static String toRGBHexString(GenericColor genericColor) {
        int n = genericColor.getRGB();
        if (n == 0) {
            return "000000";
        }
        String string = "00" + Integer.toHexString(n >> 16 & 0xFF);
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(n >> 8 & 0xFF);
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(n & 0xFF);
        string3 = string3.substring(string3.length() - 2);
        return String.valueOf(string) + string2 + string3;
    }

    public static String toCSSString(GenericColor genericColor) {
        int n = genericColor.getOpacity255();
        if (n == 255) {
            return "#" + CU.toRGBHexString(genericColor);
        }
        int n2 = genericColor.getRGB();
        return "rgba(" + (n2 >> 16 & 0xFF) + "," + (n2 >> 8 & 0xFF) + "," + (n2 & 0xFF) + "," + (float)n / 255.0f + ")";
    }

    public static int getArgbFromString(String string) {
        Object object;
        int n = 0;
        if (string == null || (n = string.length()) == 0) {
            return 0;
        }
        if ((string = string.toLowerCase()).charAt(0) == '[' && string.charAt(n - 1) == ']') {
            if (string.indexOf(",") >= 0) {
                String[] stringArray = PT.split(string.substring(1, string.length() - 1), ",");
                if (stringArray.length != 3) {
                    return 0;
                }
                float f = PT.parseFloat(stringArray[0]);
                float f2 = PT.parseFloat(stringArray[1]);
                float f3 = PT.parseFloat(stringArray[2]);
                return CU.colorTriadToFFRGB(f, f2, f3);
            }
            switch (n) {
                case 9: {
                    object = "x";
                    break;
                }
                case 10: {
                    object = "0x";
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (string.indexOf((String)object) != 1) {
                return 0;
            }
            string = "#" + string.substring(n - 7, n - 1);
            n = 7;
        }
        if (n == 7 && string.charAt(0) == '#') {
            try {
                return PT.parseIntRadix(string.substring(1, 7), 16) | 0xFF000000;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        object = mapJavaScriptColors.get(string);
        return object == null ? 0 : (Integer)object;
    }

    public static int colorTriadToFFRGB(float f, float f2, float f3) {
        if (f <= 1.0f && f2 <= 1.0f && f3 <= 1.0f) {
            if (f > 0.0f) {
                f = f * 256.0f - 1.0f;
            }
            if (f2 > 0.0f) {
                f2 = f2 * 256.0f - 1.0f;
            }
            if (f3 > 0.0f) {
                f3 = f3 * 256.0f - 1.0f;
            }
        }
        return CU.rgb((int)f, (int)f2, (int)f3);
    }

    public static int rgb(int n, int n2, int n3) {
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    public static final P3 colorPtFromString(String string) {
        return CU.colorPtFromInt(CU.getArgbFromString(string), null);
    }

    public static final P3 colorPtFromInt(int n, P3 p3) {
        if (p3 == null) {
            p3 = new P3();
        }
        p3.set(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        return p3;
    }

    public static int colorPtToFFRGB(T3 t3) {
        return CU.colorTriadToFFRGB(t3.x, t3.y, t3.z);
    }

    public static void toRGB3f(int n, float[] fArray) {
        fArray[0] = (float)(n >> 16 & 0xFF) / 255.0f;
        fArray[1] = (float)(n >> 8 & 0xFF) / 255.0f;
        fArray[2] = (float)(n & 0xFF) / 255.0f;
    }

    public static int toFFGGGfromRGB(int n) {
        int n2 = (2989 * (n >> 16 & 0xFF) + 5870 * (n >> 8 & 0xFF) + 1140 * (n & 0xFF) + 5000) / 10000 & 0xFFFFFF;
        return CU.rgb(n2, n2, n2);
    }

    public static P3 rgbToHSL(P3 p3, boolean bl) {
        float f = p3.x / 255.0f;
        float f2 = p3.y / 255.0f;
        float f3 = p3.z / 255.0f;
        float f4 = Math.min(f, Math.min(f2, f3));
        float f5 = Math.max(f, Math.max(f2, f3));
        float f6 = f5 + f4;
        float f7 = f5 - f4;
        float f8 = 60.0f * (f7 == 0.0f ? 0.0f : (f5 == f ? (f2 - f3) / f7 + 6.0f : (f5 == f2 ? (f3 - f) / f7 + 2.0f : (f - f2) / f7 + 4.0f))) % 360.0f;
        float f9 = f7 / (f7 == 0.0f ? 1.0f : (f6 <= 1.0f ? f6 : 2.0f - f6));
        return bl ? P3.new3((float)Math.round(f8 * 10.0f) / 10.0f, (float)Math.round(f9 * 1000.0f) / 10.0f, (float)Math.round(f6 * 500.0f) / 10.0f) : P3.new3(f8, f9 * 100.0f, f6 * 50.0f);
    }

    public static P3 hslToRGB(P3 p3) {
        float f;
        float f2 = Math.max(0.0f, Math.min(360.0f, p3.x)) / 60.0f;
        float f3 = Math.max(0.0f, Math.min(100.0f, p3.y)) / 100.0f;
        float f4 = f - ((double)(f = Math.max(0.0f, Math.min(100.0f, p3.z)) / 100.0f) < 0.5 ? f : 1.0f - f) * f3;
        float f5 = 2.0f * (f - f4);
        float f6 = CU.toRGB(f4, f5, f2 + 2.0f);
        float f7 = CU.toRGB(f4, f5, f2);
        float f8 = CU.toRGB(f4, f5, f2 - 2.0f);
        return P3.new3(Math.round(f6 * 255.0f), Math.round(f7 * 255.0f), Math.round(f8 * 255.0f));
    }

    private static float toRGB(float f, float f2, float f3) {
        float f4;
        f3 += (float)(f3 < 0.0f ? 6 : (f3 > 6.0f ? -6 : 0));
        return f4 < 1.0f ? f + f2 * f3 : (f3 < 3.0f ? f + f2 : (f3 < 4.0f ? f + f2 * (4.0f - f3) : f));
    }
}

