/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum.mo;

import org.jmol.quantum.MOCalculation;
import org.jmol.quantum.mo.DataAdder;

public class DataAdderF
implements DataAdder {
    @Override
    public boolean addData(MOCalculation calc, boolean havePoints) {
        double norm1;
        double norm2;
        double norm3;
        double[] coeffs = calc.coeffs;
        boolean normalizeAlpha = false;
        switch (calc.normType) {
            default: {
                norm3 = 1.0;
                norm2 = 1.0;
                norm1 = 1.0;
                break;
            }
            case 1: {
                norm1 = 5.701643762839922;
                norm2 = 3.2918455612989796;
                norm3 = 1.4721580892990938;
                normalizeAlpha = true;
                break;
            }
            case 2: {
                norm2 = norm1 = calc.getContractionNormalization(3, 1);
                norm3 = norm1;
                normalizeAlpha = true;
                break;
            }
            case 3: {
                norm1 = Math.sqrt(15.0);
                norm2 = Math.sqrt(5.0);
                norm3 = 1.0;
            }
        }
        double mxxx = coeffs[0];
        double myyy = coeffs[1];
        double mzzz = coeffs[2];
        double mxyy = coeffs[3];
        double mxxy = coeffs[4];
        double mxxz = coeffs[5];
        double mxzz = coeffs[6];
        double myzz = coeffs[7];
        double myyz = coeffs[8];
        double mxyz = coeffs[9];
        for (int ig = 0; ig < calc.nGaussians; ++ig) {
            double alpha = calc.gaussians[calc.gaussianPtr + ig][0];
            double c1 = calc.gaussians[calc.gaussianPtr + ig][1];
            calc.setE(calc.EX, alpha);
            double a = c1;
            if (normalizeAlpha) {
                a *= Math.pow(alpha, 2.25);
            }
            double axxx = a * norm3 * mxxx;
            double ayyy = a * norm3 * myyy;
            double azzz = a * norm3 * mzzz;
            double axyy = a * norm2 * mxyy;
            double axxy = a * norm2 * mxxy;
            double axxz = a * norm2 * mxxz;
            double axzz = a * norm2 * mxzz;
            double ayzz = a * norm2 * myzz;
            double ayyz = a * norm2 * myyz;
            double axyz = a * norm1 * mxyz;
            int ix = calc.xMax;
            while (--ix >= calc.xMin) {
                double x = calc.X[ix];
                double xx = x * x;
                double Ex = calc.EX[ix];
                double cxxx = axxx * xx * x;
                if (havePoints) {
                    calc.setMinMax(ix);
                }
                int iy = calc.yMax;
                while (--iy >= calc.yMin) {
                    double y = calc.Y[iy];
                    double yy = y * y;
                    double Exy = Ex * calc.EY[iy];
                    double cyyy = ayyy * yy * y;
                    double cxxy = axxy * xx * y;
                    double cxyy = axyy * x * yy;
                    float[] vd = calc.voxelDataTemp[ix][havePoints ? 0 : iy];
                    int iz = calc.zMax;
                    while (--iz >= calc.zMin) {
                        double z = calc.Z[iz];
                        double zz = z * z;
                        double czzz = azzz * zz * z;
                        double cxxz = axxz * xx * z;
                        double cxzz = axzz * x * zz;
                        double cyyz = ayyz * yy * z;
                        double cyzz = ayzz * y * zz;
                        double cxyz = axyz * x * y * z;
                        int n = havePoints ? 0 : iz;
                        vd[n] = (float)((double)vd[n] + (cxxx + cyyy + czzz + cxyy + cxxy + cxxz + cxzz + cyzz + cyyz + cxyz) * Exy * calc.EZ[iz]);
                    }
                }
            }
        }
        return true;
    }
}

