/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javajs.util.PT;
import org.jmol.api.EventManager;
import org.jmol.api.GenericMouseInterface;
import org.jmol.api.PlatformViewer;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class Mouse
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
KeyListener,
GenericMouseInterface {
    private Viewer vwr;
    private EventManager manager;
    private String keyBuffer = "";
    private boolean isMouseDown;
    private boolean wheeling;
    private int modifiersDown;
    private int xWhenPressed;
    private int yWhenPressed;
    private int modifiersWhenPressed10;

    Mouse(double privateKey, PlatformViewer vwr, Object odisplay) {
        this.vwr = (Viewer)vwr;
        this.manager = this.vwr.acm;
        Component display = (Component)odisplay;
        display.addKeyListener(this);
        display.addMouseListener(this);
        display.addMouseMotionListener(this);
        display.addMouseWheelListener(this);
    }

    @Override
    public void clear() {
    }

    @Override
    public void dispose() {
        Component display = (Component)this.vwr.display;
        display.removeMouseListener(this);
        display.removeMouseMotionListener(this);
        display.removeMouseWheelListener(this);
        display.removeKeyListener(this);
    }

    @Override
    public boolean processEvent(int id, int x, int y, int modifiers, long time) {
        modifiers = Mouse.applyLeftMouse(modifiers);
        switch (id) {
            case 501: {
                this.xWhenPressed = x;
                this.yWhenPressed = y;
                this.modifiersWhenPressed10 = modifiers;
                this.mousePressed(time, x, y, modifiers, false);
                break;
            }
            case 506: {
                this.mouseDragged(time, x, y);
                break;
            }
            case 504: {
                this.mouseEntered(time, x, y);
                break;
            }
            case 505: {
                this.mouseExited(time, x, y);
                break;
            }
            case 503: {
                this.mouseMoved(time, x, y, modifiers);
                break;
            }
            case 502: {
                this.mouseReleased(time, x, y, modifiers);
                if (x != this.xWhenPressed || y != this.yWhenPressed || modifiers != this.modifiersWhenPressed10) break;
                this.mouseClicked(time, x, y, modifiers, 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mouseClicked(e.getWhen(), e.getX(), e.getY(), e.getModifiers(), e.getClickCount());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseEntered(e.getWhen(), e.getX(), e.getY());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseExited(e.getWhen(), e.getX(), e.getY());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed(e.getWhen(), e.getX(), e.getY(), e.getModifiers(), e.isPopupTrigger());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseReleased(e.getWhen(), e.getX(), e.getY(), e.getModifiers());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragged(e.getWhen(), e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseMoved(e.getWhen(), e.getX(), e.getY(), e.getModifiers());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        this.mouseWheel(e.getWhen(), e.getWheelRotation(), e.getModifiers());
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        ke.consume();
        if (!this.vwr.menuEnabled()) {
            return;
        }
        char ch = ke.getKeyChar();
        int modifiers = ke.getModifiers();
        if (modifiers != 0 && modifiers != 1) {
            switch (ch) {
                case '\u000b': 
                case 'k': {
                    boolean isON = !this.vwr.getBooleanProperty("allowKeyStrokes");
                    switch (modifiers) {
                        case 2: {
                            this.vwr.setBooleanProperty("allowKeyStrokes", isON);
                            this.vwr.setBooleanProperty("showKeyStrokes", true);
                            break;
                        }
                        case 8: 
                        case 10: {
                            this.vwr.setBooleanProperty("allowKeyStrokes", isON);
                            this.vwr.setBooleanProperty("showKeyStrokes", false);
                        }
                    }
                    this.clearKeyBuffer();
                    this.vwr.refresh(3, "showkey");
                    break;
                }
                case '\u0016': 
                case 'v': {
                    switch (modifiers) {
                        case 2: {
                            String ret = this.vwr.getClipboardText();
                            if (ret == null) break;
                            if (ret.startsWith("http://") && ret.indexOf("\n") < 0) {
                                ret = "LoAd " + PT.esc(ret);
                            }
                            if (ret.startsWith("LoAd ")) {
                                this.vwr.evalStringQuietSync(ret, false, true);
                                break;
                            }
                            if ((ret = this.vwr.loadInlineAppend(ret, false)) != null) {
                                Logger.error(ret);
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case '\u001a': 
                case 'z': {
                    switch (modifiers) {
                        case 2: {
                            this.vwr.undoMoveAction(4165, 1);
                            break;
                        }
                        case 3: {
                            this.vwr.undoMoveAction(4140, 1);
                        }
                    }
                    break;
                }
                case '\u0019': 
                case 'y': {
                    switch (modifiers) {
                        case 2: {
                            this.vwr.undoMoveAction(4140, 1);
                        }
                    }
                }
            }
            return;
        }
        this.addKeyBuffer(ke.getModifiers() == 1 ? Character.toUpperCase(ch) : ch);
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (this.vwr.isApplet) {
            ke.consume();
        }
        this.manager.keyPressed(ke.getKeyCode(), ke.getModifiers());
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        ke.consume();
        this.manager.keyReleased(ke.getKeyCode());
    }

    @Override
    public void processKeyEvent(Object event) {
        KeyEvent e = (KeyEvent)event;
        switch (e.getID()) {
            case 401: {
                this.keyPressed(e);
                break;
            }
            case 402: {
                this.keyReleased(e);
                break;
            }
            case 400: {
                this.keyTyped(e);
            }
        }
    }

    private void clearKeyBuffer() {
        if (this.keyBuffer.length() == 0) {
            return;
        }
        this.keyBuffer = "";
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo \"\"", true, true);
        }
    }

    private void addKeyBuffer(char ch) {
        if (!this.vwr.getBooleanProperty("allowKeyStrokes")) {
            if (this.vwr.atomHighlighted >= 0) {
                this.checkElementSelected(ch);
            }
            return;
        }
        if (ch == '\n') {
            this.sendKeyBuffer();
            return;
        }
        if (ch == '\b') {
            if (this.keyBuffer.length() > 0) {
                this.keyBuffer = this.keyBuffer.substring(0, this.keyBuffer.length() - 1);
            }
        } else {
            this.keyBuffer = this.keyBuffer + ch;
        }
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo " + PT.esc("\u0001" + this.keyBuffer), true, true);
        }
    }

    private void checkElementSelected(char ch) {
        if (PT.isUpperCase(ch)) {
            this.keyBuffer = "";
        }
        this.keyBuffer = this.keyBuffer + ch;
        int elemno = Elements.elementNumberFromSymbol(this.keyBuffer, true);
        if (elemno <= 0) {
            elemno = Elements.elementNumberFromSymbol(this.keyBuffer.toUpperCase(), true);
        }
        System.out.println("CHECKELEME " + ch + " " + this.keyBuffer + " " + elemno);
        if (elemno > 0) {
            this.vwr.getModelkit(false).clickAssignAtom(this.vwr.atomHighlighted, Elements.elementSymbolFromNumber(elemno), null);
        }
        if (!PT.isUpperCase(ch)) {
            this.keyBuffer = "";
        }
    }

    private void sendKeyBuffer() {
        String kb = this.keyBuffer;
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo " + PT.esc(this.keyBuffer), true, true);
        }
        this.clearKeyBuffer();
        this.vwr.evalStringQuietSync(kb, false, true);
    }

    private void mouseEntered(long time, int x, int y) {
        this.wheeling = false;
        this.manager.mouseEnterExit(time, x, y, false);
    }

    private void mouseExited(long time, int x, int y) {
        this.wheeling = false;
        this.manager.mouseEnterExit(time, x, y, true);
    }

    private void mouseClicked(long time, int x, int y, int modifiers, int clickCount) {
        this.clearKeyBuffer();
        this.manager.mouseAction(2, time, x, y, 1, modifiers);
    }

    private void mouseMoved(long time, int x, int y, int modifiers) {
        this.clearKeyBuffer();
        if (this.isMouseDown) {
            this.manager.mouseAction(1, time, x, y, 0, this.modifiersDown);
        } else {
            this.manager.mouseAction(0, time, x, y, 0, modifiers);
        }
    }

    private void mouseWheel(long time, int rotation, int modifiers) {
        this.clearKeyBuffer();
        this.wheeling = true;
        this.manager.mouseAction(3, time, 0, rotation, 0, modifiers & 0xFFFFFFF7 | 0x20);
    }

    private void mousePressed(long time, int x, int y, int modifiers, boolean isPopupTrigger) {
        this.clearKeyBuffer();
        this.isMouseDown = true;
        this.modifiersDown = modifiers;
        this.wheeling = false;
        this.manager.mouseAction(4, time, x, y, 0, modifiers);
    }

    private void mouseReleased(long time, int x, int y, int modifiers) {
        this.isMouseDown = false;
        this.modifiersDown = 0;
        this.wheeling = false;
        this.manager.mouseAction(5, time, x, y, 0, modifiers);
    }

    private void mouseDragged(long time, int x, int y) {
        if (this.wheeling) {
            return;
        }
        if ((this.modifiersDown & 0x14) == 20) {
            this.modifiersDown = this.modifiersDown & 0xFFFFFFFB | 2;
        }
        this.manager.mouseAction(1, time, x, y, 0, this.modifiersDown);
    }

    private static int applyLeftMouse(int modifiers) {
        return (modifiers & 0x1C) == 0 ? modifiers | 0x10 : modifiers;
    }

    @Override
    public void processTwoPointGesture(float[][][] touches) {
    }
}

