/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.BufferedReader;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.api.ExportInterface;
import jspecview.api.JSVExporter;
import jspecview.api.JSVFileHelper;
import jspecview.api.JSVPanel;
import jspecview.common.Annotation;
import jspecview.common.ExportType;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.common.Spectrum;
import org.jmol.api.GenericFileInterface;

public class Exporter
implements ExportInterface {
    static final String newLine = System.getProperty("line.separator");

    @Override
    public String write(JSViewer viewer, Lst<String> tokens, boolean forInkscape) {
        if (tokens == null) {
            return this.printPDF(viewer, null, false);
        }
        String type = null;
        String fileName = null;
        JSVPanel jsvp = viewer.selectedPanel;
        try {
            switch (tokens.size()) {
                default: {
                    return "WRITE what?";
                }
                case 1: {
                    int index;
                    fileName = PT.trimQuotes((String)tokens.get(0));
                    if (fileName.indexOf(".") >= 0) {
                        type = "XY";
                    }
                    if (jsvp == null) {
                        return null;
                    }
                    ExportType eType = ExportType.getType(fileName);
                    switch (eType) {
                        case PDF: 
                        case PNG: 
                        case JPG: {
                            return this.exportTheSpectrum(viewer, eType, null, null, -1, -1, null, false);
                        }
                    }
                    viewer.fileHelper.setFileChooser(eType);
                    String[] items = this.getExportableItems(viewer, eType.equals((Object)ExportType.SOURCE));
                    int n = index = items == null ? -1 : viewer.getOptionFromDialog(items, "Export", "Choose a spectrum to export");
                    if (index == Integer.MIN_VALUE) {
                        return null;
                    }
                    GenericFileInterface file = viewer.fileHelper.getFile(this.getSuggestedFileName(viewer, eType), jsvp, true);
                    if (file == null) {
                        return null;
                    }
                    OC out = viewer.getOutputChannel(file.getFullPath(), false);
                    String msg = this.exportSpectrumOrImage(viewer, eType, index, out);
                    boolean isOK = msg.startsWith("OK");
                    if (isOK) {
                        viewer.si.siUpdateRecentMenus(file.getFullPath());
                    }
                    out.closeChannel();
                    return msg;
                }
                case 2: 
            }
            type = ((String)tokens.get(0)).toUpperCase();
            fileName = PT.trimQuotes((String)tokens.get(1));
            String ext = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase();
            if (ext.equals("BASE64")) {
                fileName = ";base64,";
            } else if (ext.equals("JDX")) {
                if (type == null) {
                    type = "XY";
                }
            } else if (ExportType.isExportMode(ext)) {
                type = ext;
            } else if (ExportType.isExportMode(type)) {
                fileName = fileName + "." + type;
            }
            ExportType eType = ExportType.getType(type);
            if (forInkscape && eType == ExportType.SVG) {
                eType = ExportType.SVGI;
            }
            OC out = viewer.getOutputChannel(fileName, false);
            return this.exportSpectrumOrImage(viewer, eType, -1, out);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private String exportSpectrumOrImage(JSViewer viewer, ExportType eType, int index, OC out) {
        PanelData pd = viewer.pd();
        if (index < 0 && (index = pd.getCurrentSpectrumIndex()) < 0) {
            return "Error exporting spectrum: No spectrum selected";
        }
        Spectrum spec = pd.getSpectrumAt(index);
        int startIndex = pd.getStartingPointIndex(index);
        int endIndex = pd.getEndingPointIndex(index);
        String msg = null;
        try {
            boolean asBase64 = out.isBase64();
            msg = this.exportTheSpectrum(viewer, eType, out, spec, startIndex, endIndex, pd, asBase64);
            if (asBase64) {
                return msg;
            }
            if (msg.startsWith("OK")) {
                return "OK - Exported " + eType.name() + ": " + out.getFileName() + msg.substring(2);
            }
        }
        catch (Exception ioe) {
            msg = ioe.toString();
        }
        return "Error exporting " + out.getFileName() + ": " + msg;
    }

    @Override
    public String exportTheSpectrum(JSViewer viewer, ExportType mode, OC out, Spectrum spec, int startIndex, int endIndex, PanelData pd, boolean asBase64) throws Exception {
        JSVPanel jsvp = viewer.selectedPanel;
        String type = mode.name();
        switch (mode) {
            case AML: 
            case CML: 
            case SVG: 
            case SVGI: {
                break;
            }
            case DIF: 
            case DIFDUP: 
            case FIX: 
            case PAC: 
            case SQZ: 
            case XY: {
                type = "JDX";
                break;
            }
            case PNG: 
            case JPG: {
                if (jsvp == null) {
                    return null;
                }
                viewer.fileHelper.setFileChooser(mode);
                String name = this.getSuggestedFileName(viewer, mode);
                GenericFileInterface file = viewer.fileHelper.getFile(name, jsvp, true);
                if (file == null) {
                    return null;
                }
                return jsvp.saveImage(type.toLowerCase(), file, out);
            }
            case PDF: {
                return this.printPDF(viewer, "PDF", asBase64);
            }
            case SOURCE: {
                if (jsvp == null) {
                    return null;
                }
                String data = jsvp.getPanelData().getSpectrum().getInlineData();
                if (data != null) {
                    out.append(data);
                    out.closeChannel();
                    return "OK " + out.getByteCount() + " bytes";
                }
                String path = jsvp.getPanelData().getSpectrum().getFilePath();
                return Exporter.fileCopy(path, out);
            }
            case UNK: {
                return null;
            }
        }
        return ((JSVExporter)JSViewer.getInterface("jspecview.export." + type.toUpperCase() + "Exporter")).exportTheSpectrum(viewer, mode, out, spec, startIndex, endIndex, null, false);
    }

    private String printPDF(JSViewer viewer, String pdfFileName, boolean isBase64) {
        boolean isJob;
        boolean bl = isJob = pdfFileName == null || pdfFileName.length() == 0;
        if (!isBase64 && !viewer.si.isSigned()) {
            return "Error: Applet must be signed for the PRINT command.";
        }
        PanelData pd = viewer.pd();
        if (pd == null) {
            return null;
        }
        boolean useDialog = false;
        pd.closeAllDialogsExcept(Annotation.AType.NONE);
        useDialog = true;
        PrintLayout pl = viewer.getDialogPrint(isJob);
        if (pl == null) {
            return null;
        }
        if (!useDialog) {
            pl.asPDF = true;
        }
        if (isJob && pl.asPDF) {
            isJob = false;
            pdfFileName = "PDF";
        }
        JSVPanel jsvp = viewer.selectedPanel;
        if (!isBase64 && !isJob) {
            GenericFileInterface file;
            JSVFileHelper helper = viewer.fileHelper;
            helper.setFileChooser(ExportType.PDF);
            if (pdfFileName.equals("?") || pdfFileName.equalsIgnoreCase("PDF")) {
                pdfFileName = this.getSuggestedFileName(viewer, ExportType.PDF);
            }
            if ((file = helper.getFile(pdfFileName, jsvp, true)) == null) {
                return null;
            }
            if (!JSViewer.isJS) {
                viewer.setProperty("directoryLastExportedFile", helper.setDirLastExported(file.getParentAsFile().getFullPath()));
            }
            pdfFileName = file.getFullPath();
        }
        String s = null;
        try {
            OC out = isJob ? null : (isBase64 ? new OC().setParams(null, ";base64,", false, null) : viewer.getOutputChannel(pdfFileName, true));
            String printJobTitle = pd.getPrintJobTitle(true);
            if (pl.showTitle && (printJobTitle = jsvp.getInput("Title?", "Title for Printing", printJobTitle)) == null) {
                return null;
            }
            jsvp.printPanel(pl, out, printJobTitle);
            s = out.toString();
        }
        catch (Exception e) {
            jsvp.showMessage(e.toString(), "File Error");
        }
        return s;
    }

    private String[] getExportableItems(JSViewer viewer, boolean isSameType) {
        PanelData pd = viewer.pd();
        boolean isView = viewer.currentSource.isView;
        int nSpectra = pd.getNumberOfSpectraInCurrentSet();
        if (nSpectra == 1 || !isView && isSameType || pd.getCurrentSpectrumIndex() >= 0) {
            return null;
        }
        String[] items = new String[nSpectra];
        for (int i = 0; i < nSpectra; ++i) {
            items[i] = pd.getSpectrumAt(i).getTitle();
        }
        return items;
    }

    private String getSuggestedFileName(JSViewer viewer, ExportType imode) {
        int pt;
        PanelData pd = viewer.pd();
        String sourcePath = pd.getSpectrum().getFilePath();
        String newName = JSVFileManager.getTagName(sourcePath);
        if (newName.startsWith("$")) {
            newName = newName.substring(1);
        }
        String name = (pt = newName.lastIndexOf(".")) < 0 ? newName : newName.substring(0, pt);
        String ext = ".jdx";
        boolean isPrint = false;
        switch (imode) {
            case DIF: 
            case DIFDUP: 
            case FIX: 
            case PAC: 
            case SQZ: 
            case XY: 
            case SOURCE: {
                if (!name.endsWith("_" + (Object)((Object)imode))) {
                    name = name + "_" + (Object)((Object)imode);
                }
                ext = ".jdx";
                break;
            }
            case AML: {
                ext = ".xml";
                break;
            }
            case PDF: 
            case PNG: 
            case JPG: {
                isPrint = true;
            }
            default: {
                ext = "." + imode.toString().toLowerCase();
            }
        }
        if (viewer.currentSource.isView) {
            name = pd.getPrintJobTitle(isPrint);
        }
        name = name + ext;
        return name;
    }

    private static String fileCopy(String name, OC out) {
        try {
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(name);
            String line = null;
            while ((line = br.readLine()) != null) {
                out.append(line);
                out.append(newLine);
            }
            out.closeChannel();
            return "OK " + out.getByteCount() + " bytes";
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

