/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import javajs.util.Lst;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTree;
import jspecview.api.JSVTreeNode;
import jspecview.api.JSVTreePath;
import jspecview.api.ScriptInterface;
import jspecview.application.AwtTreeNode;
import jspecview.application.AwtTreePath;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelNode;
import jspecview.source.JDXSource;

public class AwtTree
extends JTree
implements JSVTree {
    private static final long serialVersionUID = 1L;
    protected ScriptInterface si;
    private JSVTreeNode rootNode;
    private DefaultTreeModel spectraTreeModel;
    protected JSViewer vwr;

    @Override
    public JSVTreeNode getRootNode() {
        return this.rootNode;
    }

    public AwtTree(JSViewer viewer) {
        final JSViewer v = this.vwr = viewer;
        this.rootNode = new AwtTreeNode("Spectra", null);
        this.spectraTreeModel = new DefaultTreeModel((TreeNode)((Object)this.rootNode));
        this.setModel(this.spectraTreeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                v.selectedTreeNode((JSVTreeNode)AwtTree.this.getLastSelectedPathComponent());
            }
        });
        this.setRootVisible(false);
    }

    @Override
    public void setSelectedPanel(ScriptInterface si, JSVPanel jsvp) {
        if (jsvp != null) {
            JSVTreeNode treeNode = PanelNode.findNode((JSVPanel)jsvp, this.vwr.panelNodes).treeNode;
            this.scrollPathToVisible((TreePath)((Object)this.vwr.spectraTree.newTreePath(treeNode.getPath())));
            this.setSelectionPath((TreePath)((Object)this.vwr.spectraTree.newTreePath(treeNode.getPath())));
        }
    }

    @Override
    public JSVTreeNode createTree(int fileCount, JDXSource source, JSVPanel[] panels) {
        AwtTree tree = (AwtTree)this.vwr.spectraTree;
        JSVTreeNode rootNode = tree.getRootNode();
        Lst<PanelNode> panelNodes = this.vwr.panelNodes;
        String fileName = JSVFileManager.getTagName(source.getFilePath());
        PanelNode panelNode = new PanelNode(null, fileName, source, null);
        AwtTreeNode fileNode = new AwtTreeNode(fileName, panelNode);
        panelNode.setTreeNode(fileNode);
        tree.spectraTreeModel.insertNodeInto(fileNode, (MutableTreeNode)((Object)rootNode), rootNode.getChildCount());
        tree.scrollPathToVisible(new TreePath(fileNode.getPath()));
        for (int i = 0; i < panels.length; ++i) {
            JSVPanel jsvp = panels[i];
            String id = fileCount + "." + (i + 1);
            panelNode = new PanelNode(id, fileName, source, jsvp);
            AwtTreeNode treeNode = new AwtTreeNode(panelNode.toString(), panelNode);
            panelNode.setTreeNode(treeNode);
            panelNodes.addLast(panelNode);
            tree.spectraTreeModel.insertNodeInto(treeNode, fileNode, fileNode.getChildCount());
            tree.scrollPathToVisible(new TreePath(treeNode.getPath()));
        }
        this.vwr.selectFrameNode(panels[0]);
        return fileNode;
    }

    @Override
    public void setPath(JSVTreePath path) {
        this.setSelectionPath((TreePath)((Object)path));
    }

    @Override
    public JSVTreePath newTreePath(Object[] path) {
        return new AwtTreePath(path);
    }

    @Override
    public void deleteNodes(Lst<JSVTreeNode> toDelete) {
        for (int i = 0; i < toDelete.size(); ++i) {
            this.spectraTreeModel.removeNodeFromParent((MutableTreeNode)toDelete.get(i));
        }
    }
}

