/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import javajs.util.BS;
import javajs.util.OC;
import javajs.util.T3;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;
import org.jmol.viewer.Viewer;

public class PLYWriter {
    private IsosurfaceMesh imesh;
    boolean isBinary;
    boolean writeShorts;
    private OC oc;
    private int[][] polygonIndexes;
    private boolean selectedPolyOnly;
    private BS bsPolygons;
    private boolean haveBsDisplay;
    private int vertexCount;
    private int[] mapJmolToPLY;
    private int[] mapPLYToJmol;

    Object write(IsosurfaceMesh isosurfaceMesh, boolean isBinary) {
        this.imesh = isosurfaceMesh;
        this.isBinary = isBinary;
        this.setup();
        BS bsPoly = new BS();
        BS bsVert = new BS();
        this.checkTriangles(bsPoly, bsVert);
        int nP = bsPoly.cardinality();
        int nV = bsVert.cardinality();
        this.mapJmolToPLY = new int[this.vertexCount];
        this.mapPLYToJmol = new int[nV];
        int v = 0;
        int i = bsVert.nextSetBit(0);
        while (i >= 0) {
            this.mapPLYToJmol[v] = i;
            this.mapJmolToPLY[i] = v++;
            i = bsVert.nextSetBit(i + 1);
        }
        this.writeShorts = nV <= Short.MAX_VALUE;
        this.writePLYHeader(nV, nP);
        this.writeVertices(nV);
        this.writeTriangles(bsPoly);
        this.oc.closeChannel();
        return isBinary ? this.oc.toByteArray() : (byte[])this.oc.toString();
    }

    private void writeVertices(int nV) {
        boolean haveVertexColors = !this.imesh.isColorSolid && this.imesh.vcs != null;
        short cx = 0;
        if (!haveVertexColors) {
            cx = this.imesh.colix;
        }
        for (int i = 0; i < nV; ++i) {
            if (haveVertexColors) {
                cx = this.imesh.vcs[this.mapPLYToJmol[i]];
            }
            int color = C.getArgb(cx);
            this.outputXYZ(this.imesh.vs[this.mapPLYToJmol[i]], color);
        }
    }

    private void writeTriangles(BS bsPoly) {
        int i = bsPoly.nextSetBit(0);
        while (i >= 0) {
            int[] polygon = this.polygonIndexes[i];
            int iA = this.mapJmolToPLY[polygon[0]];
            int iB = this.mapJmolToPLY[polygon[1]];
            int iC = this.mapJmolToPLY[polygon[2]];
            this.outputTriangle(iA, iB, iC);
            i = bsPoly.nextSetBit(i + 1);
        }
    }

    private void checkTriangles(BS bsPoly, BS bsVert) {
        int i = this.imesh.pc;
        while (--i >= 0) {
            int[] polygon = this.polygonIndexes[i];
            if (polygon == null || this.selectedPolyOnly && !this.bsPolygons.get(i)) continue;
            int iA = polygon[0];
            if (this.imesh.jvxlData.thisSet != null && this.imesh.vertexSets != null && !this.imesh.jvxlData.thisSet.get(this.imesh.vertexSets[iA])) continue;
            int iB = polygon[1];
            int iC = polygon[2];
            if (this.haveBsDisplay && (!this.imesh.bsDisplay.get(iA) || !this.imesh.bsDisplay.get(iB) || !this.imesh.bsDisplay.get(iC)) || iA == iB || iB == iC || iA == iC) continue;
            bsPoly.set(i);
            bsVert.set(iA);
            bsVert.set(iB);
            bsVert.set(iC);
        }
    }

    private void setup() {
        this.oc = this.imesh.vwr.getOutputChannel(null, null);
        if (this.isBinary) {
            this.oc.setBigEndian(false);
        }
        this.vertexCount = this.imesh.vc;
        this.polygonIndexes = this.imesh.pis;
        this.haveBsDisplay = this.imesh.bsDisplay != null;
        this.selectedPolyOnly = this.imesh.bsSlabDisplay != null;
        this.bsPolygons = this.selectedPolyOnly ? this.imesh.bsSlabDisplay : null;
    }

    private void writePLYHeader(int nV, int nT) {
        String format = this.isBinary ? "binary_little_endian" : "ascii";
        this.oc.append("ply\nformat " + format + " 1.0\ncomment Created by Jmol " + Viewer.getJmolVersion() + "\nelement vertex " + nV + "\nproperty float x\nproperty float y\nproperty float z\nproperty uchar red\nproperty uchar green\nproperty uchar blue\nelement face " + nT + "\nproperty list uchar " + (this.writeShorts ? "short" : "int") + " vertex_indices\nend_header\n");
    }

    private void outputInt(int i) {
        if (this.isBinary) {
            this.oc.writeInt(i);
        } else {
            this.oc.append(" " + i);
        }
    }

    private void outputXYZ(T3 pt, int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (this.isBinary) {
            this.oc.writeFloat(pt.x);
            this.oc.writeFloat(pt.y);
            this.oc.writeFloat(pt.z);
            this.oc.writeByteAsInt(r);
            this.oc.writeByteAsInt(g);
            this.oc.writeByteAsInt(b);
        } else {
            this.oc.append(pt.x + " " + pt.y + " " + pt.z + " " + r + " " + g + " " + b + "\n");
        }
    }

    private void outputTriangle(int iA, int iB, int iC) {
        if (this.isBinary) {
            this.oc.writeByteAsInt(3);
            if (this.writeShorts) {
                this.oc.writeShort((short)iA);
                this.oc.writeShort((short)iB);
                this.oc.writeShort((short)iC);
            } else {
                this.outputInt(iA);
                this.outputInt(iB);
                this.outputInt(iC);
            }
        } else {
            this.oc.append("3 " + iA + " " + iB + " " + iC + "\n");
        }
    }
}

