/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import javajs.util.BS;
import javajs.util.PT;
import org.iupac.InChIStructureProvider;
import org.jmol.api.JmolInChI;
import org.jmol.inchi.InchiToSmilesConverter;
import org.jmol.viewer.Viewer;

public abstract class InchiJmol
implements JmolInChI,
InChIStructureProvider {
    protected boolean inputInChI;
    protected String inchi;
    protected String smilesOptions;
    protected boolean doGetSmiles;
    protected boolean getInchiModel;
    protected boolean getKey;
    protected boolean optionalFixedH;

    protected String setParameters(String options, Object molData, BS atoms, Viewer vwr) {
        boolean inputInChI;
        String smilesOptions;
        if (atoms == null ? molData == null : atoms.isEmpty()) {
            return null;
        }
        if (options == null) {
            options = "";
        }
        String inchi = null;
        String lc = options.toLowerCase().trim();
        boolean getSmiles = lc.indexOf("smiles") == 0;
        boolean getInchiModel = lc.indexOf("model") == 0;
        boolean getKey = lc.indexOf("key") >= 0;
        String string = smilesOptions = getSmiles ? options : null;
        if (lc.startsWith("model/")) {
            inchi = options.substring(10);
            lc = "";
            options = "";
        } else if (getInchiModel) {
            lc = lc.substring(5);
        }
        boolean optionalFixedH = options.indexOf("fixedh?") >= 0;
        boolean bl = inputInChI = molData instanceof String && ((String)molData).startsWith("InChI=");
        if (inputInChI) {
            inchi = (String)molData;
        } else {
            options = lc;
            if (getKey) {
                options = options.replace("inchikey", "");
                options = options.replace("key", "");
            }
            if (optionalFixedH) {
                String fxd = this.getInchi(vwr, atoms, molData, options.replace('?', ' '));
                options = PT.rep(options, "fixedh?", "");
                String std = this.getInchi(vwr, atoms, molData, options);
                inchi = fxd != null && fxd.length() <= std.length() ? std : fxd;
            }
        }
        this.optionalFixedH = optionalFixedH;
        this.inputInChI = inputInChI;
        this.doGetSmiles = getSmiles;
        this.inchi = inchi;
        this.getKey = getKey;
        this.smilesOptions = smilesOptions;
        this.getInchiModel = getInchiModel;
        return options;
    }

    protected String getSmiles(Viewer vwr, String smilesOptions) {
        return new InchiToSmilesConverter(this).getSmiles(vwr, smilesOptions);
    }
}

