/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.util;

import java.lang.reflect.Field;
import org.apache.groovy.contracts.util.Validate;

public class FieldValues {
    public static <T> T fieldValue(Object obj, String fieldName, Class<T> type) throws IllegalAccessException {
        Validate.notNull(obj);
        Validate.notNull(fieldName);
        Field f = FieldValues.findField(obj.getClass(), "thisObject");
        if (f == null) {
            throw new IllegalArgumentException("Field thisObject could not be found!");
        }
        f.setAccessible(true);
        Object target = f.get(obj);
        f = FieldValues.findField(target.getClass(), fieldName);
        if (f == null) {
            throw new IllegalArgumentException("Field " + fieldName + " could not be found!");
        }
        f.setAccessible(true);
        return (T)f.get(target);
    }

    private static Field findField(Class<?> clazz, String name) {
        for (Class<?> next = clazz; !Object.class.equals(next) && next != null; next = next.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = next.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }
}

