/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ginq.provider.collection.runtime;

import groovy.lang.Tuple2;
import groovy.transform.Internal;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.groovy.ginq.provider.collection.runtime.Null;
import org.apache.groovy.ginq.provider.collection.runtime.QueryableCollection;
import org.apache.groovy.ginq.provider.collection.runtime.Window;
import org.apache.groovy.ginq.provider.collection.runtime.WindowDefinition;

@Internal
public interface Queryable<T> {
    public static final Object NULL = Null.INSTANCE;
    public static final Queryable EMPTY_QUERYABLE = Queryable.from(new Object[0]);

    public static <T> Queryable<T> emptyQueryable() {
        return EMPTY_QUERYABLE;
    }

    public static <T> Queryable<T> from(Iterable<T> iterable) {
        return new QueryableCollection<T>(iterable);
    }

    public static <T> Queryable<T> from(T[] array) {
        return new QueryableCollection<T>(Arrays.asList(array));
    }

    public static <T> Queryable<T> from(Stream<T> sourceStream) {
        return new QueryableCollection<T>(sourceStream);
    }

    public static <T> Queryable<T> from(Queryable<T> queryable) {
        return queryable;
    }

    public <U> Queryable<Tuple2<T, U>> innerJoin(Queryable<? extends U> var1, BiPredicate<? super T, ? super U> var2);

    public <U> Queryable<Tuple2<T, U>> innerHashJoin(Queryable<? extends U> var1, Function<? super T, ?> var2, Function<? super U, ?> var3);

    public <U> Queryable<Tuple2<T, U>> leftJoin(Queryable<? extends U> var1, BiPredicate<? super T, ? super U> var2);

    public <U> Queryable<Tuple2<T, U>> leftHashJoin(Queryable<? extends U> var1, Function<? super T, ?> var2, Function<? super U, ?> var3);

    public <U> Queryable<Tuple2<T, U>> rightJoin(Queryable<? extends U> var1, BiPredicate<? super T, ? super U> var2);

    public <U> Queryable<Tuple2<T, U>> rightHashJoin(Queryable<? extends U> var1, Function<? super T, ?> var2, Function<? super U, ?> var3);

    public <U> Queryable<Tuple2<T, U>> fullJoin(Queryable<? extends U> var1, BiPredicate<? super T, ? super U> var2);

    public <U> Queryable<Tuple2<T, U>> fullHashJoin(Queryable<? extends U> var1, Function<? super T, ?> var2, Function<? super U, ?> var3);

    public <U> Queryable<Tuple2<T, U>> crossJoin(Queryable<? extends U> var1);

    public Queryable<T> where(Predicate<? super T> var1);

    public Queryable<Tuple2<?, Queryable<T>>> groupBy(Function<? super T, ?> var1, Predicate<? super Tuple2<?, Queryable<? extends T>>> var2);

    default public Queryable<Tuple2<?, Queryable<T>>> groupBy(Function<? super T, ?> classifier) {
        return this.groupBy(classifier, null);
    }

    public <U extends Comparable<? super U>> Queryable<T> orderBy(Order<? super T, ? extends U> ... var1);

    default public <U extends Comparable<? super U>> Queryable<T> orderBy(List<? extends Order<? super T, ? extends U>> orders) {
        return this.orderBy(orders.toArray(Order.EMPTY_ARRAY));
    }

    public Queryable<T> limit(long var1, long var3);

    default public Queryable<T> limit(long size) {
        return this.limit(0L, size);
    }

    public <U> Queryable<U> select(BiFunction<? super T, ? super Queryable<? extends T>, ? extends U> var1);

    default public boolean exists() {
        return this.count() > 0L;
    }

    public Queryable<T> distinct();

    default public Queryable<T> union(Queryable<? extends T> queryable) {
        return this.unionAll(queryable).distinct();
    }

    public Queryable<T> unionAll(Queryable<? extends T> var1);

    public Queryable<T> intersect(Queryable<? extends T> var1);

    public Queryable<T> minus(Queryable<? extends T> var1);

    public Long count();

    public <U> Long count(Function<? super T, ? extends U> var1);

    public BigDecimal sum(Function<? super T, ? extends Number> var1);

    public BigDecimal avg(Function<? super T, ? extends Number> var1);

    public <U extends Comparable<? super U>> U min(Function<? super T, ? extends U> var1);

    public <U extends Comparable<? super U>> U max(Function<? super T, ? extends U> var1);

    public <U> List<U> list(Function<? super T, ? extends U> var1);

    public BigDecimal median(Function<? super T, ? extends Number> var1);

    public BigDecimal stdev(Function<? super T, ? extends Number> var1);

    public BigDecimal stdevp(Function<? super T, ? extends Number> var1);

    public BigDecimal var(Function<? super T, ? extends Number> var1);

    public BigDecimal varp(Function<? super T, ? extends Number> var1);

    public <U> U agg(Function<? super Queryable<? extends T>, ? extends U> var1);

    public List<T> toList();

    public long size();

    default public Stream<T> stream() {
        return this.toList().stream();
    }

    public <U extends Comparable<? super U>> Window<T> over(Tuple2<T, Long> var1, WindowDefinition<T, U> var2);

    public static class Order<T, U extends Comparable<? super U>> {
        public static final Order[] EMPTY_ARRAY = new Order[0];
        private final Function<? super T, ? extends U> keyExtractor;
        private final boolean asc;
        private final boolean nullsLast;

        public Order(Function<? super T, ? extends U> keyExtractor, boolean asc) {
            this(keyExtractor, asc, true);
        }

        public Order(Function<? super T, ? extends U> keyExtractor, boolean asc, boolean nullsLast) {
            this.keyExtractor = keyExtractor;
            this.asc = asc;
            this.nullsLast = nullsLast;
        }

        public Function<? super T, ? extends U> getKeyExtractor() {
            return this.keyExtractor;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public boolean isNullsLast() {
            return this.nullsLast;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Order)) {
                return false;
            }
            Order order = (Order)o;
            return this.asc == order.asc && this.keyExtractor.equals(order.keyExtractor);
        }

        public int hashCode() {
            return Objects.hash(this.keyExtractor, this.asc);
        }
    }
}

