/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.gradle.util.internal.CollectionUtils;

public class MethodInvocation {
    private static final Object[] ZERO_ARGS = new Object[0];
    private final Method method;
    private final Object[] arguments;

    public MethodInvocation(Method method, Object[] args) {
        this.method = method;
        this.arguments = args == null ? ZERO_ARGS : args;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MethodInvocation other = (MethodInvocation)obj;
        if (!this.method.equals(other.method)) {
            return false;
        }
        return Arrays.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return String.format("[MethodInvocation method: %s(%s)]", this.method.getName(), CollectionUtils.join((String)", ", (Object[])this.arguments));
    }
}

