/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule;

import io.usethesource.capsule.SetEq;
import io.usethesource.capsule.factory.DefaultSetFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;

public interface Set<K>
extends java.util.Set<K>,
SetEq<K> {
    @Override
    public int size();

    @Override
    public boolean isEmpty();

    @Override
    public boolean contains(Object var1);

    @Override
    public boolean containsAll(Collection<?> var1);

    public K get(Object var1);

    default public Optional<K> findFirst() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.iterator().next());
    }

    public Iterator<K> keyIterator();

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    public static interface Transient<K>
    extends Set<K>,
    SetEq.Transient<K> {
        public boolean __insert(K var1);

        public boolean __remove(K var1);

        public boolean __insertAll(java.util.Set<? extends K> var1);

        public boolean __removeAll(java.util.Set<? extends K> var1);

        public boolean __retainAll(java.util.Set<? extends K> var1);

        public Immutable<K> freeze();

        public static <K> Transient<K> of() {
            return DefaultSetFactory.FACTORY.transientOf();
        }

        public static <K> Transient<K> of(K key0) {
            Transient<K> tmp = Transient.of();
            tmp.__insert(key0);
            return tmp;
        }

        public static <K> Transient<K> of(K key0, K key1) {
            Transient<K> tmp = Transient.of();
            tmp.__insert(key0);
            tmp.__insert(key1);
            return tmp;
        }

        public static <K> Transient<K> of(K key0, K key1, K key2) {
            Transient<K> tmp = Transient.of();
            tmp.__insert(key0);
            tmp.__insert(key1);
            tmp.__insert(key2);
            return tmp;
        }

        public static <K> Transient<K> of(K key0, K key1, K key2, K key3) {
            Transient<K> tmp = Transient.of();
            tmp.__insert(key0);
            tmp.__insert(key1);
            tmp.__insert(key2);
            tmp.__insert(key3);
            return tmp;
        }

        public static <K> Transient<K> of(K key0, K key1, K key2, K key3, K key4) {
            Transient<K> tmp = Transient.of();
            tmp.__insert(key0);
            tmp.__insert(key1);
            tmp.__insert(key2);
            tmp.__insert(key3);
            tmp.__insert(key4);
            return tmp;
        }

        public static <K> Transient<K> of(K key0, K key1, K key2, K key3, K key4, K key5) {
            Transient<K> tmp = Transient.of();
            tmp.__insert(key0);
            tmp.__insert(key1);
            tmp.__insert(key2);
            tmp.__insert(key3);
            tmp.__insert(key4);
            tmp.__insert(key5);
            return tmp;
        }
    }

    public static interface Immutable<K>
    extends Set<K>,
    SetEq.Immutable<K> {
        public Immutable<K> __insert(K var1);

        public Immutable<K> __remove(K var1);

        public Immutable<K> __insertAll(java.util.Set<? extends K> var1);

        public Immutable<K> __removeAll(java.util.Set<? extends K> var1);

        public Immutable<K> __retainAll(java.util.Set<? extends K> var1);

        default public Immutable<K> union(Immutable<K> other) {
            return Immutable.union(this, other);
        }

        default public Immutable<K> subtract(Immutable<K> other) {
            return Immutable.subtract(this, other);
        }

        default public Immutable<K> intersect(Immutable<K> other) {
            return Immutable.intersect(this, other);
        }

        public boolean isTransientSupported();

        public Transient<K> asTransient();

        public static <K> Immutable<K> of() {
            return DefaultSetFactory.FACTORY.of();
        }

        public static <K> Immutable<K> of(K item) {
            return DefaultSetFactory.FACTORY.of(item);
        }

        public static <K> Immutable<K> of(K item0, K item1) {
            return DefaultSetFactory.FACTORY.of(item0, item1);
        }

        public static <T> Immutable<T> union(Immutable<T> set1, Immutable<T> set2) {
            Immutable<T> bigger;
            Immutable<T> smaller;
            Immutable<T> unmodified;
            if (set1 == null && set2 == null) {
                return Immutable.of();
            }
            if (set1 == null) {
                return set2;
            }
            if (set2 == null) {
                return set1;
            }
            if (set1 == set2) {
                return set1;
            }
            if (set2.size() >= set1.size()) {
                unmodified = set2;
                smaller = set1;
                bigger = set2;
            } else {
                unmodified = set1;
                smaller = set2;
                bigger = set1;
            }
            Transient<T> tmp = bigger.asTransient();
            boolean modified = false;
            for (Object key : smaller) {
                if (!tmp.__insert(key)) continue;
                modified = true;
            }
            if (modified) {
                return tmp.freeze();
            }
            return unmodified;
        }

        public static <K> Immutable<K> subtract(Immutable<K> set1, Immutable<K> set2) {
            if (set1 == null && set2 == null) {
                return Immutable.of();
            }
            if (set1 == set2) {
                return Immutable.of();
            }
            if (set1 == null) {
                return Immutable.of();
            }
            if (set2 == null) {
                return set1;
            }
            Transient tmp = set1.asTransient();
            boolean modified = false;
            for (Object key : set2) {
                if (!tmp.__remove(key)) continue;
                modified = true;
            }
            if (!modified) {
                return set1;
            }
            if (tmp.isEmpty()) {
                return Immutable.of();
            }
            return tmp.freeze();
        }

        public static <K> Immutable<K> intersect(Immutable<K> set1, Immutable<K> set2) {
            Immutable<K> bigger;
            Immutable<K> smaller;
            Immutable<K> unmodified;
            if (set1 == null || set1.isEmpty()) {
                return Immutable.of();
            }
            if (set2 == null || set2.isEmpty()) {
                return Immutable.of();
            }
            if (set1 == set2) {
                return set1;
            }
            if (set2.size() >= set1.size()) {
                unmodified = set1;
                smaller = set1;
                bigger = set2;
            } else {
                unmodified = set2;
                smaller = set2;
                bigger = set1;
            }
            Transient<K> tmp = smaller.asTransient();
            boolean modified = false;
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                Object key = it.next();
                if (bigger.contains(key)) continue;
                it.remove();
                modified = true;
            }
            if (!modified) {
                return unmodified;
            }
            if (tmp.isEmpty()) {
                return Immutable.of();
            }
            return tmp.freeze();
        }
    }
}

