/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class FilteredMinimalFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree,
PatternFilterableFileTree {
    private final PatternSet patterns;
    private final FileSystemMirroringFileTree tree;

    public FilteredMinimalFileTree(PatternSet patterns, FileSystemMirroringFileTree tree) {
        this.patterns = patterns;
        this.tree = tree;
    }

    @Override
    public String getDisplayName() {
        return this.tree.getDisplayName();
    }

    public FileSystemMirroringFileTree getTree() {
        return this.tree;
    }

    public PatternSet getPatterns() {
        return this.patterns;
    }

    @Override
    public DirectoryFileTree getMirror() {
        DirectoryFileTree mirror = this.tree.getMirror();
        return mirror.filter((PatternFilterable)this.patterns);
    }

    @Override
    public MinimalFileTree filter(PatternFilterable patterns) {
        PatternSet filter = this.patterns.intersect();
        filter.copyFrom(patterns);
        return new FilteredMinimalFileTree(filter, this.tree);
    }

    @Override
    public void visitStructure(final MinimalFileTree.MinimalFileTreeStructureVisitor visitor, final FileTreeInternal owner) {
        this.tree.visitStructure(new MinimalFileTree.MinimalFileTreeStructureVisitor(){

            @Override
            public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                visitor.visitGenericFileTree(owner, FilteredMinimalFileTree.this);
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                PatternSet intersect = patterns.intersect();
                intersect.copyFrom((PatternFilterable)FilteredMinimalFileTree.this.patterns);
                visitor.visitFileTree(root, intersect, owner);
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                visitor.visitFileTreeBackedByFile(file, owner, FilteredMinimalFileTree.this);
            }
        }, owner);
    }

    @Override
    public void visit(final FileVisitor visitor) {
        final Spec spec = this.patterns.getAsSpec();
        this.tree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                if (spec.isSatisfiedBy((Object)dirDetails)) {
                    visitor.visitDir(dirDetails);
                }
            }

            public void visitFile(FileVisitDetails fileDetails) {
                if (spec.isSatisfiedBy((Object)fileDetails)) {
                    visitor.visitFile(fileDetails);
                }
            }
        });
    }
}

