/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildSession.class)
public class BuildLayoutValidator {
    private final BuildLayoutFactory buildLayoutFactory;
    private final DocumentationRegistry documentationRegistry;
    private final BuildClientMetaData clientMetaData;
    private final List<BuiltInCommand> builtInCommands;

    public BuildLayoutValidator(BuildLayoutFactory buildLayoutFactory, DocumentationRegistry documentationRegistry, BuildClientMetaData clientMetaData, List<BuiltInCommand> builtInCommands) {
        this.buildLayoutFactory = buildLayoutFactory;
        this.documentationRegistry = documentationRegistry;
        this.clientMetaData = clientMetaData;
        this.builtInCommands = builtInCommands;
    }

    public void validate(StartParameterInternal startParameter) {
        BuildLayout buildLayout = this.buildLayoutFactory.getLayoutFor(new BuildLayoutConfiguration(startParameter));
        if (!buildLayout.isBuildDefinitionMissing()) {
            return;
        }
        for (BuiltInCommand command : this.builtInCommands) {
            if (!command.commandLineMatches(startParameter.getTaskNames())) continue;
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("Directory '");
        message.append(startParameter.getCurrentDir());
        message.append("' does not contain a Gradle build.\n\n");
        message.append("A Gradle build should contain a 'settings.gradle' or 'settings.gradle.kts' file in its root directory. ");
        message.append("It may also contain a 'build.gradle' or 'build.gradle.kts' file.\n\n");
        message.append("To create a new Gradle build in this directory run '");
        this.clientMetaData.describeCommand(message, "init");
        message.append("'\n\n");
        message.append("For more detail on the 'init' task see ");
        message.append(this.documentationRegistry.getDocumentationFor("build_init_plugin"));
        message.append("\n\n");
        message.append("For more detail on creating a Gradle build see ");
        message.append(this.documentationRegistry.getDocumentationFor("tutorial_using_tasks"));
        throw new BuildLayoutException(message.toString());
    }

    private static class BuildLayoutException
    extends GradleException
    implements FailureResolutionAware {
        public BuildLayoutException(String message) {
            super(message);
        }

        @Override
        public void appendResolutions(FailureResolutionAware.Context context) {
            context.doNotSuggestResolutionsThatRequireBuildDefinition();
            context.appendResolution(output -> {
                output.text((Object)"Run ");
                context.getClientMetaData().describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), "init");
                output.text((Object)" to create a new Gradle build in this directory.");
            });
        }
    }
}

