/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classloading;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.GradleException;
import org.gradle.api.internal.classloading.ClassInfoCleaningGroovySystemLoader;
import org.gradle.api.internal.classloading.CompositeGroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.NoOpGroovySystemLoader;
import org.gradle.api.internal.classloading.PreferenceCleaningGroovySystemLoader;
import org.gradle.util.internal.VersionNumber;

public class GroovySystemLoaderFactory {
    private static final NoOpGroovySystemLoader NO_OP = new NoOpGroovySystemLoader();

    public GroovySystemLoader forClassLoader(ClassLoader classLoader) {
        try {
            Class<?> groovySystem = this.getGroovySystem(classLoader);
            if (groovySystem == null || groovySystem.getClassLoader() != classLoader) {
                return NO_OP;
            }
            GroovySystemLoader classInfoCleaningLoader = this.createClassInfoCleaningLoader(groovySystem, classLoader);
            PreferenceCleaningGroovySystemLoader preferenceCleaningLoader = new PreferenceCleaningGroovySystemLoader(classLoader);
            return new CompositeGroovySystemLoader(classInfoCleaningLoader, preferenceCleaningLoader);
        }
        catch (Exception e) {
            throw new GradleException("Could not inspect the Groovy system for ClassLoader " + classLoader, (Throwable)e);
        }
    }

    private Class<?> getGroovySystem(ClassLoader classLoader) {
        try {
            return classLoader.loadClass("groovy.lang.GroovySystem");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private GroovySystemLoader createClassInfoCleaningLoader(Class<?> groovySystem, ClassLoader classLoader) throws Exception {
        VersionNumber groovyVersion = this.getGroovyVersion(groovySystem);
        return this.isGroovy24OrLater(groovyVersion) ? new ClassInfoCleaningGroovySystemLoader(classLoader) : NO_OP;
    }

    private VersionNumber getGroovyVersion(Class<?> groovySystem) throws IllegalAccessException, InvocationTargetException {
        try {
            Method getVersion = groovySystem.getDeclaredMethod("getVersion", new Class[0]);
            String versionString = (String)getVersion.invoke(null, new Object[0]);
            return VersionNumber.parse(versionString);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private boolean isGroovy24OrLater(VersionNumber groovyVersion) {
        if (groovyVersion == null) {
            return false;
        }
        return groovyVersion.getMajor() == 2 && groovyVersion.getMinor() >= 4 || groovyVersion.getMajor() > 2;
    }
}

