/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.io;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.io.LineBufferingOutputStream;
import org.gradle.internal.io.NullOutputStream;
import org.gradle.internal.io.TextStream;

public class LinePerThreadBufferingOutputStream
extends PrintStream {
    private final TextStream handler;
    private final ThreadLocal<PrintStream> stream = new ThreadLocal();
    private final String lineSeparator = SystemProperties.getInstance().getLineSeparator();

    public LinePerThreadBufferingOutputStream(TextStream handler) {
        super(NullOutputStream.INSTANCE, true);
        this.handler = handler;
    }

    private PrintStream getStream() {
        PrintStream printStream = this.stream.get();
        if (printStream == null) {
            printStream = new PrintStream(new LineBufferingOutputStream(this.handler, this.lineSeparator));
            this.stream.set(printStream);
        }
        return printStream;
    }

    private PrintStream maybeGetStream() {
        return this.stream.get();
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.getStream().append(csq);
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.getStream().append(c);
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        this.getStream().append(csq, start, end);
        return this;
    }

    @Override
    public boolean checkError() {
        return this.getStream().checkError();
    }

    @Override
    public void close() {
        PrintStream currentStream = this.maybeGetStream();
        if (currentStream != null) {
            this.stream.remove();
            currentStream.close();
        } else {
            this.handler.endOfStream(null);
        }
    }

    @Override
    public void flush() {
        PrintStream stream = this.maybeGetStream();
        if (stream != null) {
            stream.flush();
        }
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        this.getStream().format(format, args);
        return this;
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        this.getStream().format(l, format, args);
        return this;
    }

    @Override
    public void print(boolean b) {
        this.getStream().print(b);
    }

    @Override
    public void print(char c) {
        this.getStream().print(c);
    }

    @Override
    public void print(double d) {
        this.getStream().print(d);
    }

    @Override
    public void print(float f) {
        this.getStream().print(f);
    }

    @Override
    public void print(int i) {
        this.getStream().print(i);
    }

    @Override
    public void print(long l) {
        this.getStream().print(l);
    }

    @Override
    public void print(Object obj) {
        this.getStream().print(obj);
    }

    @Override
    public void print(char[] s) {
        this.getStream().print(s);
    }

    @Override
    public void print(String s) {
        this.getStream().print(s);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        this.getStream().printf(format, args);
        return this;
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        this.getStream().printf(l, format, args);
        return this;
    }

    @Override
    public void println() {
        this.getStream().print(this.lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(boolean x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(double x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(float x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(int x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(long x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        PrintStream stream = this.getStream();
        LinePerThreadBufferingOutputStream linePerThreadBufferingOutputStream = this;
        synchronized (linePerThreadBufferingOutputStream) {
            stream.print(x);
            stream.print(this.lineSeparator);
        }
    }

    @Override
    public void write(int b) {
        this.getStream().write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.getStream().write(buf, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getStream().write(b);
    }
}

