/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import javax.tools.JavaCompiler;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.AnnotationProcessorDiscoveringCompiler;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompiler;
import org.gradle.api.internal.tasks.compile.DaemonJavaCompiler;
import org.gradle.api.internal.tasks.compile.ForkingJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaHomeBasedJavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.JdkJavaCompiler;
import org.gradle.api.internal.tasks.compile.ModuleApplicationNameWritingCompiler;
import org.gradle.api.internal.tasks.compile.NormalizingJavaCompiler;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.internal.Factory;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class DefaultJavaCompilerFactory
implements JavaCompilerFactory {
    private final WorkerDirectoryProvider workingDirProvider;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final ExecHandleFactory execHandleFactory;
    private final AnnotationProcessorDetector processorDetector;
    private final ClassPathRegistry classPathRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private Factory<JavaCompiler> javaHomeBasedJavaCompilerFactory;

    public DefaultJavaCompilerFactory(WorkerDirectoryProvider workingDirProvider, WorkerDaemonFactory workerDaemonFactory, JavaForkOptionsFactory forkOptionsFactory, ExecHandleFactory execHandleFactory, AnnotationProcessorDetector processorDetector, ClassPathRegistry classPathRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.workingDirProvider = workingDirProvider;
        this.workerDaemonFactory = workerDaemonFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.execHandleFactory = execHandleFactory;
        this.processorDetector = processorDetector;
        this.classPathRegistry = classPathRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    private Factory<JavaCompiler> getJavaHomeBasedJavaCompilerFactory() {
        if (this.javaHomeBasedJavaCompilerFactory == null) {
            this.javaHomeBasedJavaCompilerFactory = new JavaHomeBasedJavaCompilerFactory(this.classPathRegistry.getClassPath("JAVA-COMPILER-PLUGIN").getAsFiles());
        }
        return this.javaHomeBasedJavaCompilerFactory;
    }

    public <T extends CompileSpec> Compiler<T> create(Class<T> type) {
        Compiler<T> result = this.createTargetCompiler(type);
        return new ModuleApplicationNameWritingCompiler<JavaCompileSpec>(new AnnotationProcessorDiscoveringCompiler<JavaCompileSpec>(new NormalizingJavaCompiler(result), this.processorDetector));
    }

    private <T extends CompileSpec> Compiler<T> createTargetCompiler(Class<T> type) {
        if (!JavaCompileSpec.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Cannot create a compiler for a spec with type %s", type.getSimpleName()));
        }
        if (CommandLineJavaCompileSpec.class.isAssignableFrom(type)) {
            return new CommandLineJavaCompiler(this.execHandleFactory);
        }
        if (ForkingJavaCompileSpec.class.isAssignableFrom(type)) {
            return new DaemonJavaCompiler(this.workingDirProvider.getWorkingDirectory(), JdkJavaCompiler.class, new Object[]{this.getJavaHomeBasedJavaCompilerFactory()}, this.workerDaemonFactory, this.forkOptionsFactory, this.classPathRegistry, this.actionExecutionSpecFactory);
        }
        return new JdkJavaCompiler(this.getJavaHomeBasedJavaCompilerFactory());
    }
}

