/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.fingerprint.impl;

import java.util.Objects;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.execution.fingerprint.FileNormalizationSpec;
import org.gradle.internal.execution.fingerprint.impl.DefaultFileNormalizationSpec;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.LineEndingSensitivity;

public class FingerprinterRegistration {
    private final FileNormalizationSpec spec;
    private final FileCollectionFingerprinter fingerprinter;

    private FingerprinterRegistration(FileNormalizationSpec spec, FileCollectionFingerprinter fingerprinter) {
        this.spec = spec;
        this.fingerprinter = fingerprinter;
    }

    public FileNormalizationSpec getSpec() {
        return this.spec;
    }

    public FileCollectionFingerprinter getFingerprinter() {
        return this.fingerprinter;
    }

    public static FingerprinterRegistration registration(DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, FileCollectionFingerprinter fingerprinter) {
        return new FingerprinterRegistration(DefaultFileNormalizationSpec.from(fingerprinter.getRegisteredType(), directorySensitivity, lineEndingSensitivity), fingerprinter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FingerprinterRegistration that = (FingerprinterRegistration)o;
        return this.spec.equals(that.spec) && this.fingerprinter.equals(that.fingerprinter);
    }

    public int hashCode() {
        return Objects.hash(this.spec);
    }
}

