/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

public class CallMaker {
    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(0);
        }
        if (calleeExpression == null) {
            CallMaker.$$$reportNull$$$0(1);
        }
        if (argumentExpressions == null) {
            CallMaker.$$$reportNull$$$0(2);
        }
        return CallMaker.makeCallWithExpressions(callElement, explicitReceiver, callOperationNode, calleeExpression, argumentExpressions, Call.CallType.DEFAULT, false);
    }

    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions, @NotNull Call.CallType callType) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(3);
        }
        if (calleeExpression == null) {
            CallMaker.$$$reportNull$$$0(4);
        }
        if (argumentExpressions == null) {
            CallMaker.$$$reportNull$$$0(5);
        }
        if (callType == null) {
            CallMaker.$$$reportNull$$$0(6);
        }
        return CallMaker.makeCallWithExpressions(callElement, explicitReceiver, callOperationNode, calleeExpression, argumentExpressions, callType, false);
    }

    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions, @NotNull Call.CallType callType, boolean isSemanticallyEquivalentToSafeCall) {
        List arguments2;
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(7);
        }
        if (calleeExpression == null) {
            CallMaker.$$$reportNull$$$0(8);
        }
        if (argumentExpressions == null) {
            CallMaker.$$$reportNull$$$0(9);
        }
        if (callType == null) {
            CallMaker.$$$reportNull$$$0(10);
        }
        if (argumentExpressions.isEmpty()) {
            arguments2 = Collections.emptyList();
        } else {
            arguments2 = new ArrayList(argumentExpressions.size());
            for (KtExpression argumentExpression : argumentExpressions) {
                arguments2.add(CallMaker.makeValueArgument(argumentExpression, calleeExpression));
            }
        }
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, callType, isSemanticallyEquivalentToSafeCall);
    }

    @NotNull
    public static Call makeCall(KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, KtExpression calleeExpression, List<? extends ValueArgument> arguments2) {
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, Call.CallType.DEFAULT);
    }

    @NotNull
    public static Call makeCall(KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, KtExpression calleeExpression, List<? extends ValueArgument> arguments2, Call.CallType callType) {
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, callType, false);
    }

    @NotNull
    public static Call makeCall(KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, KtExpression calleeExpression, List<? extends ValueArgument> arguments2, Call.CallType callType, boolean isSemanticallyEquivalentToSafeCall) {
        return new CallImpl(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, callType, isSemanticallyEquivalentToSafeCall);
    }

    @NotNull
    public static Call makeCall(@NotNull ReceiverValue leftAsReceiver, KtBinaryExpression expression2) {
        if (leftAsReceiver == null) {
            CallMaker.$$$reportNull$$$0(11);
        }
        return CallMaker.makeCallWithExpressions(expression2, leftAsReceiver, null, expression2.getOperationReference(), Collections.singletonList(expression2.getRight()));
    }

    @NotNull
    public static Call makeCall(@NotNull ReceiverValue baseAsReceiver, KtUnaryExpression expression2) {
        if (baseAsReceiver == null) {
            CallMaker.$$$reportNull$$$0(12);
        }
        return CallMaker.makeCall(expression2, baseAsReceiver, null, expression2.getOperationReference(), Collections.emptyList());
    }

    @NotNull
    public static Call makeArraySetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull KtArrayAccessExpression arrayAccessExpression2, @NotNull KtExpression rightHandSide, @NotNull Call.CallType callType) {
        if (arrayAsReceiver == null) {
            CallMaker.$$$reportNull$$$0(13);
        }
        if (arrayAccessExpression2 == null) {
            CallMaker.$$$reportNull$$$0(14);
        }
        if (rightHandSide == null) {
            CallMaker.$$$reportNull$$$0(15);
        }
        if (callType == null) {
            CallMaker.$$$reportNull$$$0(16);
        }
        ArrayList<KtExpression> arguments2 = Lists.newArrayList(arrayAccessExpression2.getIndexExpressions());
        arguments2.add(rightHandSide);
        return CallMaker.makeCallWithExpressions(arrayAccessExpression2, arrayAsReceiver, null, arrayAccessExpression2, arguments2, callType);
    }

    @NotNull
    public static Call makeArrayGetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull KtArrayAccessExpression arrayAccessExpression2, @NotNull Call.CallType callType) {
        if (arrayAsReceiver == null) {
            CallMaker.$$$reportNull$$$0(17);
        }
        if (arrayAccessExpression2 == null) {
            CallMaker.$$$reportNull$$$0(18);
        }
        if (callType == null) {
            CallMaker.$$$reportNull$$$0(19);
        }
        return CallMaker.makeCallWithExpressions(arrayAccessExpression2, arrayAsReceiver, null, arrayAccessExpression2, arrayAccessExpression2.getIndexExpressions(), callType);
    }

    public static Call makeCallForCollectionLiteral(@NotNull KtCollectionLiteralExpression collectionLiteralExpression) {
        if (collectionLiteralExpression == null) {
            CallMaker.$$$reportNull$$$0(20);
        }
        return CallMaker.makeCallWithExpressions(collectionLiteralExpression, null, null, collectionLiteralExpression, collectionLiteralExpression.getInnerExpressions(), Call.CallType.DEFAULT);
    }

    @NotNull
    public static ValueArgument makeValueArgument(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            CallMaker.$$$reportNull$$$0(21);
        }
        return CallMaker.makeValueArgument(expression2, expression2);
    }

    @NotNull
    public static ValueArgument makeValueArgument(@Nullable KtExpression expression2, @NotNull KtElement reportErrorsOn) {
        if (reportErrorsOn == null) {
            CallMaker.$$$reportNull$$$0(22);
        }
        return new ExpressionValueArgument(expression2, reportErrorsOn, false);
    }

    @NotNull
    public static ValueArgument makeExternalValueArgument(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            CallMaker.$$$reportNull$$$0(23);
        }
        return new ExpressionValueArgument(expression2, expression2, true);
    }

    @NotNull
    public static ValueArgument makeExternalValueArgument(@NotNull KtExpression expression2, @NotNull KtElement reportErrorsOn) {
        if (expression2 == null) {
            CallMaker.$$$reportNull$$$0(24);
        }
        if (reportErrorsOn == null) {
            CallMaker.$$$reportNull$$$0(25);
        }
        return new ExpressionValueArgument(expression2, reportErrorsOn, true);
    }

    @NotNull
    public static Call makePropertyCall(@Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtSimpleNameExpression nameExpression) {
        if (nameExpression == null) {
            CallMaker.$$$reportNull$$$0(26);
        }
        return CallMaker.makeCallWithExpressions(nameExpression, explicitReceiver, callOperationNode, nameExpression, Collections.emptyList());
    }

    @NotNull
    public static Call makeConstructorCallWithoutTypeArguments(@NotNull KtCallElement callElement) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(27);
        }
        return new DelegatingCall(CallMaker.makeCall(null, null, callElement)){

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list2 = Collections.emptyList();
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getTypeArguments"));
            }
        };
    }

    @NotNull
    public static Call makeConstructorCallForEnumEntryWithoutInitializer(final @NotNull KtSuperTypeCallEntry callElement) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(28);
        }
        return new Call(){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return null;
            }

            @Override
            @Nullable
            public Receiver getExplicitReceiver() {
                return null;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List<? extends ValueArgument> list2 = callElement.getValueArguments();
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public List<? extends LambdaArgument> getFunctionLiteralArguments() {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list2;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list2 = Collections.emptyList();
                if (list2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtSuperTypeCallEntry ktSuperTypeCallEntry = callElement;
                if (ktSuperTypeCallEntry == null) {
                    2.$$$reportNull$$$0(3);
                }
                return ktSuperTypeCallEntry;
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    2.$$$reportNull$$$0(4);
                }
                return callType;
            }

            public String toString() {
                return DebugTextUtilKt.getDebugText(callElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionLiteralArguments";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeArguments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static Call makeCall(final @Nullable Receiver explicitReceiver, final @Nullable ASTNode callOperationNode, final @NotNull KtCallElement callElement) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(29);
        }
        return new Call(){

            @Override
            public ASTNode getCallOperationNode() {
                return callOperationNode;
            }

            @Override
            @Nullable
            public Receiver getExplicitReceiver() {
                return explicitReceiver;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List<? extends ValueArgument> list2 = callElement.getValueArguments();
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public List<? extends LambdaArgument> getFunctionLiteralArguments() {
                List<KtLambdaArgument> list2 = callElement.getLambdaArguments();
                if (list2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return list2;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list2 = callElement.getTypeArguments();
                if (list2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return callElement.getTypeArgumentList();
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtCallElement ktCallElement = callElement;
                if (ktCallElement == null) {
                    3.$$$reportNull$$$0(3);
                }
                return ktCallElement;
            }

            public String toString() {
                return DebugTextUtilKt.getDebugText(callElement);
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    3.$$$reportNull$$$0(4);
                }
                return callType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionLiteralArguments";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeArguments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static Call makeCall(@NotNull KtElement callElement, @NotNull ReceiverValue explicitReceiver) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(30);
        }
        if (explicitReceiver == null) {
            CallMaker.$$$reportNull$$$0(31);
        }
        return new CallImpl(callElement, explicitReceiver, null, null, Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeExpression";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentExpressions";
                break;
            }
            case 6: 
            case 10: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftAsReceiver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseAsReceiver";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAsReceiver";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightHandSide";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionLiteralExpression";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportErrorsOn";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExpression";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitReceiver";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "makeCallWithExpressions";
                break;
            }
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "makeCall";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "makeArraySetCall";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "makeArrayGetCall";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "makeCallForCollectionLiteral";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "makeValueArgument";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "makeExternalValueArgument";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "makePropertyCall";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "makeConstructorCallWithoutTypeArguments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "makeConstructorCallForEnumEntryWithoutInitializer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CallImpl
    implements Call {
        private final KtElement callElement;
        private final Receiver explicitReceiver;
        private final ASTNode callOperationNode;
        private final KtExpression calleeExpression;
        private final List<? extends ValueArgument> valueArguments;
        private final Call.CallType callType;
        private final boolean isSemanticallyEquivalentToSafeCall;

        protected CallImpl(@NotNull KtElement callElement, @NotNull Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @Nullable KtExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments) {
            if (callElement == null) {
                CallImpl.$$$reportNull$$$0(0);
            }
            if (explicitReceiver == null) {
                CallImpl.$$$reportNull$$$0(1);
            }
            if (valueArguments == null) {
                CallImpl.$$$reportNull$$$0(2);
            }
            this(callElement, explicitReceiver, callOperationNode, calleeExpression, valueArguments, Call.CallType.DEFAULT, false);
        }

        protected CallImpl(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @Nullable KtExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments, @NotNull Call.CallType callType, boolean isSemanticallyEquivalentToSafeCall) {
            if (callElement == null) {
                CallImpl.$$$reportNull$$$0(3);
            }
            if (valueArguments == null) {
                CallImpl.$$$reportNull$$$0(4);
            }
            if (callType == null) {
                CallImpl.$$$reportNull$$$0(5);
            }
            this.callElement = callElement;
            this.explicitReceiver = explicitReceiver;
            this.callOperationNode = callOperationNode;
            this.calleeExpression = calleeExpression;
            this.valueArguments = valueArguments;
            this.callType = callType;
            this.isSemanticallyEquivalentToSafeCall = isSemanticallyEquivalentToSafeCall;
        }

        @Override
        public ASTNode getCallOperationNode() {
            return this.callOperationNode;
        }

        @Override
        public boolean isSemanticallyEquivalentToSafeCall() {
            return this.isSemanticallyEquivalentToSafeCall || Call.super.isSemanticallyEquivalentToSafeCall();
        }

        @Override
        @Nullable
        public Receiver getExplicitReceiver() {
            return this.explicitReceiver;
        }

        @Override
        @Nullable
        public ReceiverValue getDispatchReceiver() {
            return null;
        }

        @Override
        public KtExpression getCalleeExpression() {
            return this.calleeExpression;
        }

        @Override
        @NotNull
        public List<? extends ValueArgument> getValueArguments() {
            List<? extends ValueArgument> list2 = this.valueArguments;
            if (list2 == null) {
                CallImpl.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @Override
        @NotNull
        public KtElement getCallElement() {
            KtElement ktElement = this.callElement;
            if (ktElement == null) {
                CallImpl.$$$reportNull$$$0(7);
            }
            return ktElement;
        }

        @Override
        public KtValueArgumentList getValueArgumentList() {
            return null;
        }

        @NotNull
        public List<LambdaArgument> getFunctionLiteralArguments() {
            List<LambdaArgument> list2 = Collections.emptyList();
            if (list2 == null) {
                CallImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<KtTypeProjection> getTypeArguments() {
            List<KtTypeProjection> list2 = Collections.emptyList();
            if (list2 == null) {
                CallImpl.$$$reportNull$$$0(9);
            }
            return list2;
        }

        @Override
        public KtTypeArgumentList getTypeArgumentList() {
            return null;
        }

        public String toString() {
            return this.getCallElement().getText();
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = this.callType;
            if (callType == null) {
                CallImpl.$$$reportNull$$$0(10);
            }
            return callType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "explicitReceiver";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueArguments";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callType";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueArguments";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallElement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionLiteralArguments";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExpressionValueArgument
    implements ValueArgument {
        private final KtExpression expression;
        private final KtElement reportErrorsOn;
        private final boolean isExternal;

        private ExpressionValueArgument(@Nullable KtExpression expression2, @NotNull KtElement reportErrorsOn, boolean isExternal) {
            if (reportErrorsOn == null) {
                ExpressionValueArgument.$$$reportNull$$$0(0);
            }
            this.expression = expression2;
            this.reportErrorsOn = expression2 == null ? reportErrorsOn : expression2;
            this.isExternal = isExternal;
        }

        @Override
        public boolean isExternal() {
            return this.isExternal;
        }

        @Override
        public KtExpression getArgumentExpression() {
            return this.expression;
        }

        @Override
        public ValueArgumentName getArgumentName() {
            return null;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        @NotNull
        public KtElement asElement() {
            KtElement ktElement = this.reportErrorsOn;
            if (ktElement == null) {
                ExpressionValueArgument.$$$reportNull$$$0(1);
            }
            return ktElement;
        }

        @Override
        public LeafPsiElement getSpreadElement() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionValueArgument argument2 = (ExpressionValueArgument)o;
            return !(this.expression != null ? !this.expression.equals(argument2.expression) : argument2.expression != null);
        }

        public int hashCode() {
            return this.expression != null ? this.expression.hashCode() : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reportErrorsOn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$ExpressionValueArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$ExpressionValueArgument";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

