/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "()V", "tryCalculateReturnTypeOrNull", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "providers"})
public final class ReturnTypeCalculatorForFullBodyResolve
extends ReturnTypeCalculator {
    @NotNull
    public static final ReturnTypeCalculatorForFullBodyResolve INSTANCE = new ReturnTypeCalculatorForFullBodyResolve();

    private ReturnTypeCalculatorForFullBodyResolve() {
    }

    @Override
    @Nullable
    public FirResolvedTypeRef tryCalculateReturnTypeOrNull(@NotNull FirCallableDeclaration declaration) {
        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirTypeRef returnTypeRef = declaration.getReturnTypeRef();
        if (returnTypeRef instanceof FirResolvedTypeRef) {
            return (FirResolvedTypeRef)returnTypeRef;
        }
        if (declaration.getOrigin().getFromSupertypes()) {
            return FakeOverrideTypeCalculator.Forced.INSTANCE.computeReturnType(declaration);
        }
        boolean $i$f$buildErrorTypeRef = false;
        FirErrorTypeRefBuilder $this$tryCalculateReturnTypeOrNull_u24lambda_u2d0 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
        boolean bl = false;
        $this$tryCalculateReturnTypeOrNull_u24lambda_u2d0.setDiagnostic(new ConeSimpleDiagnostic("Cannot calculate return type during full-body resolution (local class/object?): " + FirRendererKt.render$default(declaration, null, 1, null), DiagnosticKind.InferenceError));
        return firErrorTypeRefBuilder.build();
    }
}

