/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;

public final class CharSequenceHashingStrategy
implements TObjectHashingStrategy<CharSequence> {
    public static final CharSequenceHashingStrategy CASE_SENSITIVE = new CharSequenceHashingStrategy(true);
    public static final CharSequenceHashingStrategy CASE_INSENSITIVE = new CharSequenceHashingStrategy(false);
    private final boolean myCaseSensitive;

    private CharSequenceHashingStrategy(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
    }

    public int computeHashCode(CharSequence chars) {
        return this.myCaseSensitive ? StringUtil.stringHashCode(chars) : StringUtil.stringHashCodeInsensitive(chars);
    }

    public boolean equals(CharSequence s1, CharSequence s2) {
        return Comparing.equal(s1, s2, this.myCaseSensitive);
    }
}

