/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.internal;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import groovy.util.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.GradleScriptException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.plugins.scala.ScalaPluginExtension;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.internal.Cast;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.internal.IdeaIsolatedProjectsWorkarounds;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.ModuleLibrary;
import org.gradle.plugins.ide.idea.model.ProjectLibrary;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;
import org.gradle.util.internal.VersionNumber;

public class IdeaScalaConfigurer {
    private static final VersionNumber IDEA_VERSION_WHEN_SCALA_SDK_WAS_INTRODUCED = VersionNumber.version((int)14);
    public static final String DEFAULT_SCALA_PLATFORM_VERSION = "2.10.7";
    private final Project rootProject;
    private final Consumer<Collection<Project>> onScalaProjects;

    public IdeaScalaConfigurer(Project rootProject, Consumer<Collection<Project>> onScalaProjects) {
        this.rootProject = rootProject;
        this.onScalaProjects = onScalaProjects;
    }

    public void configure() {
        this.rootProject.getGradle().projectsEvaluated((Action)new Action<Gradle>(){

            public void execute(Gradle gradle) {
                VersionNumber ideaTargetVersion = IdeaScalaConfigurer.this.findIdeaTargetVersion();
                final boolean useScalaSdk = ideaTargetVersion == null || IDEA_VERSION_WHEN_SCALA_SDK_WAS_INTRODUCED.compareTo(ideaTargetVersion) <= 0;
                final Collection scalaProjects = IdeaScalaConfigurer.this.findProjectsApplyingIdeaAndScalaPlugins();
                IdeaScalaConfigurer.this.onScalaProjects.accept(scalaProjects);
                final LinkedHashMap scalaCompilerLibraries = new LinkedHashMap();
                IdeaScalaConfigurer.this.rootProject.getTasks().named("ideaProject", (Action)new Action<Task>(){

                    public void execute(Task task) {
                        task.doFirst((Action)new Action<Task>(){

                            public void execute(Task task) {
                                if (scalaProjects.size() > 0) {
                                    scalaCompilerLibraries.clear();
                                    scalaCompilerLibraries.putAll(IdeaScalaConfigurer.resolveScalaCompilerLibraries(scalaProjects, useScalaSdk));
                                    IdeaScalaConfigurer.this.declareUniqueProjectLibraries(Sets.newLinkedHashSet(scalaCompilerLibraries.values()));
                                }
                            }
                        });
                    }
                });
                IdeaScalaConfigurer.this.rootProject.configure((Iterable)scalaProjects, (Action)new Action<Project>(){

                    public void execute(final Project project) {
                        ((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getModule().getIml().withXml((Action)new Action<XmlProvider>(){

                            public void execute(XmlProvider xmlProvider) {
                                if (useScalaSdk) {
                                    IdeaScalaConfigurer.declareScalaSdk((ProjectLibrary)scalaCompilerLibraries.get(project.getPath()), xmlProvider.asNode());
                                } else {
                                    IdeaScalaConfigurer.declareScalaFacet((ProjectLibrary)scalaCompilerLibraries.get(project.getPath()), xmlProvider.asNode());
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private static Map<String, ProjectLibrary> resolveScalaCompilerLibraries(Collection<Project> scalaProjects, boolean useScalaSdk) {
        LinkedHashMap<String, ProjectLibrary> scalaCompilerLibraries = new LinkedHashMap<String, ProjectLibrary>();
        for (Project scalaProject : scalaProjects) {
            ProjectState owner = ((ProjectInternal)scalaProject).getOwner();
            ProjectLibrary library = (ProjectLibrary)owner.fromMutableState(p -> IdeaScalaConfigurer.createScalaSdkLibrary((Project)p, useScalaSdk));
            ProjectLibrary duplicate = (ProjectLibrary)Iterables.find(scalaCompilerLibraries.values(), (Predicate)Predicates.equalTo((Object)library), null);
            scalaCompilerLibraries.put(owner.getIdentity().getProjectPath().toString(), duplicate == null ? library : duplicate);
        }
        return scalaCompilerLibraries;
    }

    private static Iterable<File> getIdeaModuleLibraryDependenciesAsFiles(IdeaModule ideaModule) {
        Set<Dependency> dependencies = ideaModule.resolveDependencies();
        ArrayList<File> files = new ArrayList<File>();
        for (ModuleLibrary moduleLibrary : Iterables.filter(dependencies, ModuleLibrary.class)) {
            for (FilePath filePath : Iterables.filter((Iterable)moduleLibrary.getClasses(), FilePath.class)) {
                files.add(filePath.getFile());
            }
        }
        return files;
    }

    private static ProjectLibrary createScalaSdkLibrary(Project scalaProject, boolean useScalaSdk) {
        FileCollection scalaClasspath;
        ScalaPluginExtension scalaPluginExtension = (ScalaPluginExtension)scalaProject.getExtensions().getByType(ScalaPluginExtension.class);
        if (scalaPluginExtension.getScalaVersion().isPresent()) {
            String scalaVersion = (String)scalaPluginExtension.getScalaVersion().get();
            Configuration toolchainClasspath = scalaProject.getConfigurations().getByName("scalaToolchainRuntimeClasspath");
            return IdeaScalaConfigurer.createScalaSdkFromScalaVersion(scalaVersion, toolchainClasspath.getIncoming().getFiles(), useScalaSdk);
        }
        IdeaModule ideaModule = ((IdeaModel)scalaProject.getExtensions().getByType(IdeaModel.class)).getModule();
        Iterable<File> files = IdeaScalaConfigurer.getIdeaModuleLibraryDependenciesAsFiles(ideaModule);
        ScalaRuntime runtime = (ScalaRuntime)scalaProject.getExtensions().getByType(ScalaRuntime.class);
        File compilerJar = runtime.findScalaJar((Iterable)(scalaClasspath = runtime.inferScalaClasspath(files)), "compiler");
        if (compilerJar == null) {
            compilerJar = runtime.findScalaJar((Iterable)scalaClasspath, "compiler_3");
        }
        String scalaVersion = compilerJar != null ? runtime.getScalaVersion(compilerJar) : DEFAULT_SCALA_PLATFORM_VERSION;
        return IdeaScalaConfigurer.createScalaSdkFromScalaVersion(scalaVersion, scalaClasspath, useScalaSdk);
    }

    private static ProjectLibrary createScalaSdkFromScalaVersion(String version, FileCollection scalaClasspath, boolean useScalaSdk) {
        if (useScalaSdk) {
            return IdeaScalaConfigurer.createScalaSdkLibrary("scala-sdk-" + version, (Iterable<File>)scalaClasspath);
        }
        return IdeaScalaConfigurer.createProjectLibrary("scala-compiler-" + version, (Iterable<File>)scalaClasspath);
    }

    private void declareUniqueProjectLibraries(Set<ProjectLibrary> projectLibraries) {
        Set<ProjectLibrary> existingLibraries = ((IdeaModel)this.rootProject.getExtensions().getByType(IdeaModel.class)).getProject().getProjectLibraries();
        Sets.SetView newLibraries = Sets.difference(projectLibraries, existingLibraries);
        for (ProjectLibrary newLibrary : newLibraries) {
            String originalName = newLibrary.getName();
            int suffix = 1;
            while (IdeaScalaConfigurer.containsLibraryWithSameName(existingLibraries, newLibrary.getName())) {
                newLibrary.setName(originalName + "-" + suffix++);
            }
            existingLibraries.add(newLibrary);
        }
    }

    private static boolean containsLibraryWithSameName(Set<ProjectLibrary> libraries, String name) {
        return libraries.stream().anyMatch(library -> Objects.equal((Object)library.getName(), (Object)name));
    }

    private static void declareScalaSdk(ProjectLibrary scalaSdkLibrary, Node iml) {
        if (scalaSdkLibrary != null) {
            Node newModuleRootManager = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue((Node)iml, (String)"component", (String)"name", (String)"NewModuleRootManager");
            Node sdkLibrary = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue((Node)newModuleRootManager, (String)"orderEntry", (String)"name", (String)scalaSdkLibrary.getName());
            IdeaScalaConfigurer.setNodeAttribute(sdkLibrary, "type", "library");
            IdeaScalaConfigurer.setNodeAttribute(sdkLibrary, "level", "project");
        }
    }

    private static void declareScalaFacet(ProjectLibrary scalaCompilerLibrary, Node iml) {
        Node facetManager = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue((Node)iml, (String)"component", (String)"name", (String)"FacetManager");
        Node scalaFacet = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue((Node)facetManager, (String)"facet", (String)"type", (String)"scala");
        IdeaScalaConfigurer.setNodeAttribute(scalaFacet, "name", "Scala");
        Node configuration = XmlPersistableConfigurationObject.findOrCreateFirstChildNamed((Node)scalaFacet, (String)"configuration");
        Node libraryLevel = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue((Node)configuration, (String)"option", (String)"name", (String)"compilerLibraryLevel");
        IdeaScalaConfigurer.setNodeAttribute(libraryLevel, "value", "Project");
        Node libraryName = XmlPersistableConfigurationObject.findOrCreateFirstChildWithAttributeValue((Node)configuration, (String)"option", (String)"name", (String)"compilerLibraryName");
        IdeaScalaConfigurer.setNodeAttribute(libraryName, "value", scalaCompilerLibrary.getName());
    }

    private static void setNodeAttribute(Node node, String key, String value) {
        Map attributes = (Map)Cast.uncheckedCast((Object)node.attributes());
        attributes.put(key, value);
    }

    private Collection<Project> findProjectsApplyingIdeaAndScalaPlugins() {
        return Collections2.filter((Collection)this.rootProject.getAllprojects(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                boolean hasIdeaPlugin = IdeaIsolatedProjectsWorkarounds.hasPlugin(project, IdeaPlugin.class);
                boolean hasScalaPlugin = IdeaIsolatedProjectsWorkarounds.hasPlugin(project, ScalaBasePlugin.class);
                return hasIdeaPlugin && hasScalaPlugin;
            }
        });
    }

    private VersionNumber findIdeaTargetVersion() {
        VersionNumber targetVersion = null;
        String targetVersionString = ((IdeaModel)this.rootProject.getExtensions().getByType(IdeaModel.class)).getTargetVersion();
        if (targetVersionString != null && (targetVersion = VersionNumber.parse((String)targetVersionString)).equals((Object)VersionNumber.UNKNOWN)) {
            throw new GradleScriptException("String '" + targetVersionString + "' is not a valid value for IdeaModel.targetVersion.", null);
        }
        return targetVersion;
    }

    private static ProjectLibrary createProjectLibrary(String name, Iterable<File> jars) {
        ProjectLibrary projectLibrary = new ProjectLibrary();
        projectLibrary.setName(name);
        projectLibrary.setClasses((Set)Sets.newLinkedHashSet(jars));
        return projectLibrary;
    }

    private static ProjectLibrary createScalaSdkLibrary(String name, Iterable<File> jars) {
        ProjectLibrary projectLibrary = new ProjectLibrary();
        projectLibrary.setName(name);
        projectLibrary.setType("Scala");
        projectLibrary.setCompilerClasspath((Set)Sets.newLinkedHashSet(jars));
        return projectLibrary;
    }
}

