/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J4\u0010\r\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVisibilityQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClassLikeSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isStandalone", "", "toInvisibleCompanion", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirVisibilityQualifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirVisibilityQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVisibilityQualifierChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,91:1\n26#2:92\n*S KotlinDebug\n*F\n+ 1 FirVisibilityQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVisibilityQualifierChecker\n*L\n72#1:92\n*E\n"})
public final class FirVisibilityQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirVisibilityQualifierChecker INSTANCE = new FirVisibilityQualifierChecker();

    private FirVisibilityQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedQualifier expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
        if (firClassLikeSymbol == null) {
            return;
        }
        this.checkClassLikeSymbol(firClassLikeSymbol, expression2, FirHelpersKt.isStandalone(expression2, context), context, reporter);
    }

    private final void checkClassLikeSymbol(FirClassLikeSymbol<?> symbol, FirResolvedQualifier expression2, boolean isStandalone, CheckerContext context, DiagnosticReporter reporter) {
        block9: {
            Object object;
            Object it;
            FirFile firFile = context.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile firFile2 = firFile;
            KtSourceElement ktSourceElement = expression2.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitReceiver.INSTANCE) && !FirVisibilityCheckerKt.getVisibilityChecker(context.getSession()).isClassLikeVisible((FirClassLikeDeclaration)FirVisibilityCheckerKt.getFirForVisibilityChecker((FirBasedSymbol)symbol), context.getSession(), firFile2, context.getContainingDeclarations())) {
                if (!(expression2 instanceof FirErrorResolvedQualifier) || !(((FirErrorResolvedQualifier)expression2).getDiagnostic() instanceof ConeVisibilityError)) {
                    reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)symbol, expression2.getSource()), context);
                }
                return;
            }
            if (isStandalone) {
                FirRegularClassSymbol invisibleCompanion;
                FirRegularClassSymbol firRegularClassSymbol = expression2.getSymbol();
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol != null && (firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(firRegularClassSymbol, context.getSession())) != null ? this.toInvisibleCompanion(firRegularClassSymbol, context) : (invisibleCompanion = null);
                if (invisibleCompanion != null) {
                    if (!(expression2 instanceof FirErrorResolvedQualifier) || !(((FirErrorResolvedQualifier)expression2).getDiagnostic() instanceof ConeVisibilityError)) {
                        reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(invisibleCompanion, expression2.getSource()), context);
                    }
                    return;
                }
            }
            if (symbol instanceof FirTypeAliasSymbol) {
                Object object2;
                FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAliasSymbol)symbol).getResolvedExpandedTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                if ((object2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null && (object2 = TypeUtilsKt.toSymbol((ConeClassLikeType)object2, context.getSession())) != null) {
                    it = object2;
                    boolean bl = false;
                    INSTANCE.checkClassLikeSymbol((FirClassLikeSymbol<?>)it, expression2, isStandalone, context, reporter);
                }
            }
            if ((object = FirVisibilityCheckerKt.getOwnerLookupTag((FirBasedSymbol)symbol)) == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context.getSession())) == null) break block9;
            it = object;
            boolean bl = false;
            INSTANCE.checkClassLikeSymbol((FirClassLikeSymbol<?>)it, expression2, false, context, reporter);
        }
    }

    private final FirRegularClassSymbol toInvisibleCompanion(FirRegularClassSymbol $this$toInvisibleCompanion, CheckerContext context) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirFile firFile = context.getContainingFile();
        if (firFile == null) {
            return null;
        }
        FirFile firFile2 = firFile;
        FirRegularClassSymbol firRegularClassSymbol2 = $this$toInvisibleCompanion.getCompanionObjectSymbol();
        if (firRegularClassSymbol2 != null) {
            FirRegularClassSymbol firRegularClassSymbol3;
            FirRegularClassSymbol it = firRegularClassSymbol3 = firRegularClassSymbol2;
            boolean bl = false;
            firRegularClassSymbol = !FirVisibilityCheckerKt.getVisibilityChecker(context.getSession()).isClassLikeVisible((FirClassLikeDeclaration)FirVisibilityCheckerKt.getFirForVisibilityChecker((FirBasedSymbol)it), context.getSession(), firFile2, context.getContainingDeclarations()) ? firRegularClassSymbol3 : null;
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }
}

