/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.lower.GenerateMultifileFacadesKt;
import org.jetbrains.kotlin.backend.jvm.lower.UpdateConstantFacadePropertyReferences;
import org.jetbrains.kotlin.backend.jvm.lower.UpdateFunctionCallSites;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;

@PhaseDescription(name="GenerateMultifileFacades", description="Generate JvmMultifileClass facades, based on the information provided by FileClassLowering")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/GenerateMultifileFacades;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backend.jvm.lower"})
public final class GenerateMultifileFacades
implements ModuleLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public GenerateMultifileFacades(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        Map functionDelegates = new LinkedHashMap();
        boolean shouldGeneratePartHierarchy = this.context.getConfig().getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getInheritMultifileParts());
        irModule.getFiles().addAll(GenerateMultifileFacadesKt.access$generateMultifileFacades(irModule, this.context, shouldGeneratePartHierarchy, functionDelegates));
        new UpdateFunctionCallSites(functionDelegates).lower(irModule);
        new UpdateConstantFacadePropertyReferences(this.context, shouldGeneratePartHierarchy).lower(irModule);
        this.context.getMultifileFacadesToAdd().clear();
        for (Map.Entry entry : functionDelegates.entrySet()) {
            IrSimpleFunction member = (IrSimpleFunction)entry.getKey();
            IrSimpleFunction newMember = (IrSimpleFunction)entry.getValue();
            JvmIrAttributesKt.setMultifileFacadePartMember(newMember, member);
        }
    }
}

