/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;

public class DefaultCurrentFileCollectionFingerprint
implements CurrentFileCollectionFingerprint {
    private final Map<String, FileSystemLocationFingerprint> fingerprints;
    private final FingerprintHashingStrategy hashingStrategy;
    private final String identifier;
    private final FileSystemSnapshot roots;
    private final ImmutableMultimap<String, HashCode> rootHashes;
    private final HashCode strategyConfigurationHash;
    private HashCode hash;

    public static CurrentFileCollectionFingerprint from(FileSystemSnapshot roots, FingerprintingStrategy strategy, @Nullable FileCollectionFingerprint candidate) {
        if (roots == FileSystemSnapshot.EMPTY) {
            return strategy.getEmptyFingerprint();
        }
        ImmutableListMultimap<String, HashCode> rootHashes = SnapshotUtil.getRootHashes(roots);
        Map<String, FileSystemLocationFingerprint> fingerprints = candidate != null && candidate.wasCreatedWithStrategy(strategy) && DefaultCurrentFileCollectionFingerprint.equalRootHashes(candidate.getRootHashes(), rootHashes) ? candidate.getFingerprints() : strategy.collectFingerprints(roots);
        if (fingerprints.isEmpty()) {
            return strategy.getEmptyFingerprint();
        }
        return new DefaultCurrentFileCollectionFingerprint(fingerprints, roots, (ImmutableMultimap<String, HashCode>)rootHashes, strategy);
    }

    private static boolean equalRootHashes(ImmutableMultimap<String, HashCode> first, ImmutableMultimap<String, HashCode> second) {
        return Iterables.elementsEqual((Iterable)first.entries(), (Iterable)second.entries());
    }

    private DefaultCurrentFileCollectionFingerprint(Map<String, FileSystemLocationFingerprint> fingerprints, FileSystemSnapshot roots, ImmutableMultimap<String, HashCode> rootHashes, FingerprintingStrategy strategy) {
        this.fingerprints = fingerprints;
        this.identifier = strategy.getIdentifier();
        this.hashingStrategy = strategy.getHashingStrategy();
        this.strategyConfigurationHash = strategy.getConfigurationHash();
        this.roots = roots;
        this.rootHashes = rootHashes;
    }

    @Override
    public HashCode getHash() {
        if (this.hash == null) {
            Hasher hasher = Hashing.newHasher();
            this.hashingStrategy.appendToHasher(hasher, this.fingerprints.values());
            this.hash = hasher.hash();
        }
        return this.hash;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> getFingerprints() {
        return this.fingerprints;
    }

    @Override
    public ImmutableMultimap<String, HashCode> getRootHashes() {
        return this.rootHashes;
    }

    @Override
    public boolean wasCreatedWithStrategy(FingerprintingStrategy strategy) {
        return strategy.getConfigurationHash().equals((Object)this.strategyConfigurationHash);
    }

    @Override
    public String getStrategyIdentifier() {
        return this.identifier;
    }

    @Override
    public FileSystemSnapshot getSnapshot() {
        return this.roots;
    }

    @Override
    public FileCollectionFingerprint archive(CurrentFileCollectionFingerprint.ArchivedFileCollectionFingerprintFactory factory) {
        return factory.createArchivedFileCollectionFingerprint(this.fingerprints, this.rootHashes, this.strategyConfigurationHash);
    }

    public String toString() {
        return this.identifier + this.fingerprints;
    }
}

