/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.extensions;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.extensions.ReplFactoryExtension;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.ReplCompiler;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.GenericReplCompiler;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00122\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/extensions/JvmStandardReplFactoryExtension;", "Lorg/jetbrains/kotlin/cli/common/extensions/ReplFactoryExtension;", "<init>", "()V", "makeReplCompiler", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "templateClassName", "", "templateClasspath", "", "Ljava/io/File;", "baseClassLoader", "Ljava/lang/ClassLoader;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "projectEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment;", "makeScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "kotlin-scripting-compiler"})
@SourceDebugExtension(value={"SMAP\nJvmStandardReplFactoryExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmStandardReplFactoryExtension.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/extensions/JvmStandardReplFactoryExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,45:1\n1557#2:46\n1628#2,3:47\n37#3,2:50\n*S KotlinDebug\n*F\n+ 1 JvmStandardReplFactoryExtension.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/extensions/JvmStandardReplFactoryExtension\n*L\n37#1:46\n37#1:47,3\n37#1:50,2\n*E\n"})
public final class JvmStandardReplFactoryExtension
implements ReplFactoryExtension {
    @NotNull
    public ReplCompiler makeReplCompiler(@NotNull String templateClassName, @NotNull List<? extends File> templateClasspath, @Nullable ClassLoader baseClassLoader, @NotNull CompilerConfiguration configuration, @NotNull JavaCoreProjectEnvironment projectEnvironment) {
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)projectEnvironment, (String)"projectEnvironment");
        Disposable disposable = projectEnvironment.getParentDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getParentDisposable(...)");
        KotlinScriptDefinition kotlinScriptDefinition = this.makeScriptDefinition(templateClasspath, templateClassName, baseClassLoader);
        Object object = configuration.getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getNotNull(...)");
        return new GenericReplCompiler(disposable, kotlinScriptDefinition, configuration, (MessageCollector)object);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinScriptDefinition makeScriptDefinition(List<? extends File> templateClasspath, String templateClassName, ClassLoader baseClassLoader) {
        KotlinScriptDefinition kotlinScriptDefinition;
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = templateClasspath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toURI().toURL());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ClassLoader classLoader = baseClassLoader;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            URLClassLoader classloader = new URLClassLoader(uRLArray, classLoader);
            Class<?> cls = classloader.loadClass(templateClassName);
            Intrinsics.checkNotNull(cls);
            kotlinScriptDefinition = (KotlinScriptDefinition)new KotlinScriptDefinitionFromAnnotatedTemplate(JvmClassMappingKt.getKotlinClass(cls), MapsKt.emptyMap(), null, 4, null);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Cannot find script definition template class " + templateClassName, ex);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error loading script definition template " + templateClassName, ex);
        }
        return kotlinScriptDefinition;
    }
}

