/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.util.HashMap;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.file.DuplicateFileCopyingException;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.util.internal.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateHandlingCopyActionDecorator
implements CopyAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateHandlingCopyActionDecorator.class);
    private final CopyAction delegate;
    private final CopySpecInternal spec;
    private final DocumentationRegistry documentationRegistry;

    public DuplicateHandlingCopyActionDecorator(CopyAction delegate, CopySpecInternal spec, DocumentationRegistry documentationRegistry) {
        this.delegate = delegate;
        this.spec = spec;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public WorkResult execute(CopyActionProcessingStream stream) {
        HashMap visitedFiles = new HashMap();
        return this.delegate.execute(action -> stream.process(details -> {
            if (!details.isDirectory()) {
                DuplicatesStrategy strategy = details.getDuplicatesStrategy();
                RelativePath relativePath = details.getRelativePath();
                if (visitedFiles.containsKey(relativePath)) {
                    if (details.isDefaultDuplicatesStrategy()) {
                        this.failWithIncorrectDuplicatesStrategySetup(relativePath);
                    }
                    if (strategy == DuplicatesStrategy.EXCLUDE) {
                        return;
                    }
                    if (strategy == DuplicatesStrategy.FAIL) {
                        throw new DuplicateFileCopyingException(String.format("Cannot copy %s to '%s' because %s has already been copied there.", details.getDisplayName(), this.buildFormattedOutputPath(relativePath), visitedFiles.get(relativePath)));
                    }
                    if (strategy == DuplicatesStrategy.WARN) {
                        LOGGER.warn("{} will be copied to '{}', overwriting {}, which has already been copied there.", new Object[]{details.getDisplayName(), this.buildFormattedOutputPath(relativePath), visitedFiles.get(relativePath)});
                    }
                } else {
                    visitedFiles.put(relativePath, details.getDisplayName());
                }
            }
            action.processFile(details);
        }));
    }

    private String buildFormattedOutputPath(RelativePath relativePath) {
        return TextUtil.toPlatformLineSeparators((String)(this.spec.getDestinationDir() == null ? relativePath.getPathString() : new File(this.spec.getDestinationDir(), relativePath.getPathString()).getPath()));
    }

    private void failWithIncorrectDuplicatesStrategySetup(RelativePath relativePath) {
        throw new InvalidUserCodeException("Entry " + relativePath.getPathString() + " is a duplicate but no duplicate handling strategy has been set. Please refer to " + this.documentationRegistry.getDslRefForProperty("org.gradle.api.tasks.Copy", "duplicatesStrategy") + " for details.");
    }
}

