/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.core;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceScope(value={Scope.BuildTree.class})
public class GradleEnterprisePluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleEnterprisePluginManager.class);
    @VisibleForTesting
    public static final String NO_SCAN_PLUGIN_MSG = "An internal error occurred that prevented a build scan from being created.\nPlease report this via https://github.com/gradle/gradle/issues";
    public static final String OLD_SCAN_PLUGIN_VERSION_MESSAGE = "The build scan plugin is not compatible with this version of Gradle.\nPlease see https://gradle.com/help/gradle-6-build-scan-plugin for more information.";
    @Nullable
    private GradleEnterprisePluginAdapter adapter;
    private boolean unsupported;

    @Nullable
    public GradleEnterprisePluginAdapter getAdapter() {
        return this.adapter;
    }

    public void registerAdapter(GradleEnterprisePluginAdapter adapter) {
        if (this.unsupported) {
            throw new IllegalStateException("plugin already noted as unsupported");
        }
        this.adapter = adapter;
    }

    public void unsupported() {
        if (this.adapter != null) {
            throw new IllegalStateException("plugin already noted as supported");
        }
        this.unsupported = true;
    }

    public boolean isPresent() {
        return this.adapter != null;
    }

    public void buildFinished(@Nullable Throwable buildFailure) {
        if (this.adapter != null) {
            this.adapter.buildFinished(buildFailure);
        }
    }

    public void registerMissingPluginWarning(GradleInternal gradle) {
        if (gradle.isRootBuild()) {
            boolean requested;
            StartParameterInternal startParameter = gradle.getStartParameter();
            boolean bl = requested = !startParameter.isNoBuildScan() && startParameter.isBuildScan();
            if (requested) {
                gradle.addListener(new InternalBuildAdapter(){

                    public void settingsEvaluated(@Nonnull Settings settings) {
                        if (!GradleEnterprisePluginManager.this.isPresent() && !GradleEnterprisePluginManager.this.unsupported) {
                            LOGGER.warn(GradleEnterprisePluginManager.NO_SCAN_PLUGIN_MSG);
                        }
                    }
                });
            }
        }
    }
}

