/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import javax.annotation.Nullable;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.internal.Describables;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;

public class VintageBuildModelController
implements BuildModelController {
    private final ProjectsPreparer projectsPreparer;
    private final GradleInternal gradle;
    private final SettingsPreparer settingsPreparer;
    private final TaskExecutionPreparer taskExecutionPreparer;
    private final StateTransitionController<Stage> state;

    public VintageBuildModelController(GradleInternal gradle, ProjectsPreparer projectsPreparer, SettingsPreparer settingsPreparer, TaskExecutionPreparer taskExecutionPreparer, StateTransitionControllerFactory controllerFactory) {
        this.gradle = gradle;
        this.projectsPreparer = projectsPreparer;
        this.settingsPreparer = settingsPreparer;
        this.taskExecutionPreparer = taskExecutionPreparer;
        this.state = controllerFactory.newController(Describables.of((Object)"vintage state of", (Object)gradle.getOwner().getDisplayName()), Stage.Created);
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        this.prepareSettings();
        return this.gradle.getSettings();
    }

    @Override
    public GradleInternal getConfiguredModel() {
        this.prepareSettings();
        this.prepareProjects();
        return this.gradle;
    }

    @Override
    public void prepareToScheduleTasks() {
        this.prepareSettings();
        this.prepareProjects();
    }

    @Override
    public void scheduleRequestedTasks(@Nullable EntryTaskSelector selector, ExecutionPlan plan) {
        this.state.inState(Stage.Configured, () -> this.taskExecutionPreparer.scheduleRequestedTasks(this.gradle, selector, plan));
    }

    private void prepareSettings() {
        this.state.transitionIfNotPreviously(Stage.Created, Stage.SettingsLoaded, () -> this.settingsPreparer.prepareSettings(this.gradle));
    }

    private void prepareProjects() {
        this.state.transitionIfNotPreviously(Stage.SettingsLoaded, Stage.Configured, () -> this.projectsPreparer.prepareProjects(this.gradle));
    }

    private static enum Stage implements StateTransitionController.State
    {
        Created,
        SettingsLoaded,
        Configured;

    }
}

