/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecSpec;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultProcessForkOptions;
import org.gradle.process.internal.ProcessArgumentsSpec;
import org.gradle.process.internal.ProcessStreamsSpec;

public class DefaultExecSpec
extends DefaultProcessForkOptions
implements ExecSpec,
ProcessArgumentsSpec.HasExecutable {
    private boolean ignoreExitValue;
    private final ProcessStreamsSpec streamsSpec = new ProcessStreamsSpec();
    private final ProcessArgumentsSpec argumentsSpec = new ProcessArgumentsSpec(this);

    @Inject
    public DefaultExecSpec(PathToFileResolver resolver) {
        super(resolver);
    }

    public void copyTo(ExecSpec targetSpec) {
        super.copyTo((ProcessForkOptions)targetSpec);
        DefaultExecSpec.copyBaseExecSpecTo((BaseExecSpec)this, (BaseExecSpec)targetSpec);
        targetSpec.setArgs(this.getArgs());
        targetSpec.getArgumentProviders().addAll(this.getArgumentProviders());
    }

    static void copyBaseExecSpecTo(BaseExecSpec source, BaseExecSpec target) {
        target.setIgnoreExitValue(source.isIgnoreExitValue());
        if (source.getStandardInput() != null) {
            target.setStandardInput(source.getStandardInput());
        }
        if (source.getStandardOutput() != null) {
            target.setStandardOutput(source.getStandardOutput());
        }
        if (source.getErrorOutput() != null) {
            target.setErrorOutput(source.getErrorOutput());
        }
    }

    public List<String> getCommandLine() {
        return this.argumentsSpec.getCommandLine();
    }

    public ExecSpec commandLine(Object ... arguments) {
        this.argumentsSpec.commandLine(arguments);
        return this;
    }

    public ExecSpec commandLine(Iterable<?> args) {
        this.argumentsSpec.commandLine(args);
        return this;
    }

    public void setCommandLine(List<String> args) {
        this.argumentsSpec.commandLine(args);
    }

    public void setCommandLine(Object ... args) {
        this.argumentsSpec.commandLine(args);
    }

    public void setCommandLine(Iterable<?> args) {
        this.argumentsSpec.commandLine(args);
    }

    public ExecSpec args(Object ... args) {
        this.argumentsSpec.args(args);
        return this;
    }

    public ExecSpec args(Iterable<?> args) {
        this.argumentsSpec.args(args);
        return this;
    }

    public ExecSpec setArgs(List<String> arguments) {
        this.argumentsSpec.setArgs(arguments);
        return this;
    }

    public ExecSpec setArgs(Iterable<?> arguments) {
        this.argumentsSpec.setArgs(arguments);
        return this;
    }

    public List<String> getArgs() {
        return this.argumentsSpec.getArgs();
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentsSpec.getArgumentProviders();
    }

    public ExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExitValue = ignoreExitValue;
        return this;
    }

    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    public BaseExecSpec setStandardInput(InputStream inputStream) {
        this.streamsSpec.setStandardInput(inputStream);
        return this;
    }

    public InputStream getStandardInput() {
        return this.streamsSpec.getStandardInput();
    }

    public BaseExecSpec setStandardOutput(OutputStream outputStream) {
        this.streamsSpec.setStandardOutput(outputStream);
        return this;
    }

    public OutputStream getStandardOutput() {
        return this.streamsSpec.getStandardOutput();
    }

    public BaseExecSpec setErrorOutput(OutputStream outputStream) {
        this.streamsSpec.setErrorOutput(outputStream);
        return this;
    }

    public OutputStream getErrorOutput() {
        return this.streamsSpec.getErrorOutput();
    }
}

