/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.GlobalDependencySubstitutionRegistry;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.work.Synchronizer;
import org.gradle.internal.work.WorkerLeaseService;

@ServiceScope(value={Scope.BuildTree.class})
public class BuildInclusionCoordinator {
    private final Set<IncludedBuildState> loadedBuilds = new CopyOnWriteArraySet<IncludedBuildState>();
    private final List<IncludedBuildState> libraryBuilds = new CopyOnWriteArrayList<IncludedBuildState>();
    private final Map<BuildState, BuildSynchronizer> synchronizers = new ConcurrentHashMap<BuildState, BuildSynchronizer>();
    private final GlobalDependencySubstitutionRegistry substitutionRegistry;
    private final WorkerLeaseService workerLeaseService;
    private boolean registerRootSubstitutions;

    public BuildInclusionCoordinator(GlobalDependencySubstitutionRegistry substitutionRegistry, WorkerLeaseService workerLeaseService) {
        this.substitutionRegistry = substitutionRegistry;
        this.workerLeaseService = workerLeaseService;
    }

    public void prepareForInclusion(IncludedBuildState build, boolean asPlugin) {
        if (this.loadedBuilds.add(build)) {
            build.ensureProjectsLoaded();
        }
        if (!asPlugin && !this.libraryBuilds.contains(build)) {
            this.libraryBuilds.add(build);
        }
    }

    public void prepareRootBuildForInclusion() {
        this.registerRootSubstitutions = true;
    }

    private void registerGlobalLibrarySubstitutions() {
        for (IncludedBuildState includedBuild : this.libraryBuilds) {
            this.registerSubstitutionsFor(includedBuild);
        }
    }

    public void registerSubstitutionsAvailableFor(BuildState build) {
        if (build instanceof RootBuildState) {
            this.registerGlobalLibrarySubstitutions();
        } else {
            this.withLockForBuild(build, () -> this.makeSubstitutionsAvailableFor(build));
        }
    }

    public void registerSubstitutionsProvidedBy(BuildState build) {
        if (build instanceof RootBuildState && this.registerRootSubstitutions) {
            this.registerSubstitutionsFor((RootBuildState)build);
        }
    }

    public void prepareForPluginResolution(IncludedBuildState build) {
        this.withLockForBuild(build, build::ensureProjectsConfigured);
        this.makeSubstitutionsAvailableFor(build);
    }

    private void makeSubstitutionsAvailableFor(BuildState build) {
        ArrayDeque<BuildState> stack = new ArrayDeque<BuildState>();
        HashSet<BuildState> seen = new HashSet<BuildState>();
        stack.push(build);
        seen.add(build);
        while (!stack.isEmpty()) {
            BuildState current = (BuildState)stack.pop();
            for (IncludedBuildInternal includedBuildInternal : current.getMutableModel().includedBuilds()) {
                BuildState child = includedBuildInternal.getTarget();
                if (!seen.add(child) || !(child instanceof IncludedBuildState)) continue;
                this.registerSubstitutionsFor((IncludedBuildState)child);
                stack.push(child);
            }
        }
    }

    private void registerSubstitutionsFor(CompositeBuildParticipantBuildState build) {
        this.withLockForBuild(build, () -> this.substitutionRegistry.registerSubstitutionsFor(build));
    }

    private void withLockForBuild(BuildState build, Runnable action) {
        this.synchronizers.computeIfAbsent(build, b -> new BuildSynchronizer(this.workerLeaseService)).withLock(action);
    }

    private static class BuildSynchronizer {
        final Synchronizer lock;
        boolean isInProgress;

        BuildSynchronizer(WorkerLeaseService workerLeaseService) {
            this.lock = workerLeaseService.newResource();
        }

        void withLock(Runnable action) {
            this.lock.withLock(() -> {
                if (this.isInProgress) {
                    return;
                }
                try {
                    this.isInProgress = true;
                    action.run();
                }
                finally {
                    this.isInProgress = false;
                }
            });
        }
    }
}

