/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import javax.annotation.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;

public class LogEventDispatcher
implements OutputEventListener {
    private final OutputEventListener stdoutChain;
    private final OutputEventListener stderrChain;

    public LogEventDispatcher(@Nullable OutputEventListener stdoutChain, @Nullable OutputEventListener stderrChain) {
        this.stdoutChain = stdoutChain;
        this.stderrChain = stderrChain;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event.getLogLevel() == null) {
            this.dispatch(event, this.stdoutChain);
            this.dispatch(event, this.stderrChain);
        } else if (event.getLogLevel() == LogLevel.ERROR) {
            this.dispatch(event, this.stderrChain);
        } else {
            this.dispatch(event, this.stdoutChain);
        }
    }

    protected void dispatch(OutputEvent event, OutputEventListener listener) {
        if (listener != null) {
            listener.onOutput(event);
        }
    }
}

