/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import jcifs.smb.ACE;
import jcifs.smb.ServerMessageBlock;

public class SecurityDescriptor {
    public int type;
    public ACE[] aces;

    public SecurityDescriptor() {
    }

    public SecurityDescriptor(byte[] buffer, int bufferIndex, int len) throws IOException {
        this.decode(buffer, bufferIndex, len);
    }

    public int decode(byte[] buffer, int bufferIndex, int len) throws IOException {
        int start = bufferIndex++;
        this.type = ServerMessageBlock.readInt2(buffer, ++bufferIndex);
        ServerMessageBlock.readInt4(buffer, bufferIndex += 2);
        ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        int daclOffset = ServerMessageBlock.readInt4(buffer, bufferIndex += 4);
        bufferIndex = start + daclOffset;
        ++bufferIndex;
        int size = ServerMessageBlock.readInt2(buffer, ++bufferIndex);
        int numAces = ServerMessageBlock.readInt4(buffer, bufferIndex += 2);
        bufferIndex += 4;
        if (numAces > 4096) {
            throw new IOException("Invalid SecurityDescriptor");
        }
        if (daclOffset != 0) {
            this.aces = new ACE[numAces];
            for (int i = 0; i < numAces; ++i) {
                this.aces[i] = new ACE();
                bufferIndex += this.aces[i].decode(buffer, bufferIndex);
            }
        } else {
            this.aces = null;
        }
        return bufferIndex - start;
    }

    public String toString() {
        String ret = "SecurityDescriptor:\n";
        if (this.aces != null) {
            for (int ai = 0; ai < this.aces.length; ++ai) {
                ret = ret + this.aces[ai].toString() + "\n";
            }
        } else {
            ret = ret + "NULL";
        }
        return ret;
    }
}

