/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import org.gradle.api.internal.jvm.JavaVersionParser;

public enum JavaVersion {
    VERSION_1_1,
    VERSION_1_2,
    VERSION_1_3,
    VERSION_1_4,
    VERSION_1_5,
    VERSION_1_6,
    VERSION_1_7,
    VERSION_1_8,
    VERSION_1_9,
    VERSION_1_10,
    VERSION_11,
    VERSION_12,
    VERSION_13,
    VERSION_14,
    VERSION_15,
    VERSION_16,
    VERSION_17,
    VERSION_18,
    VERSION_19,
    VERSION_20,
    VERSION_21,
    VERSION_22,
    VERSION_23,
    VERSION_24,
    VERSION_25,
    VERSION_26,
    VERSION_27,
    VERSION_HIGHER;

    private static final int FIRST_MAJOR_VERSION_ORDINAL = 8;
    private static final int CLASS_MAJOR_VERSION_OFFSET = 44;
    private static JavaVersion currentJavaVersion;
    private final String versionName = this.ordinal() >= 8 ? this.getMajorVersion() : "1." + this.getMajorVersion();

    public static JavaVersion toVersion(Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        if (value instanceof JavaVersion) {
            return (JavaVersion)((Object)value);
        }
        if (value instanceof Integer) {
            return JavaVersion.getVersionForMajor((Integer)value);
        }
        String name = value.toString();
        return JavaVersion.getVersionForMajor(JavaVersionParser.parseMajorVersion(name));
    }

    public static JavaVersion current() {
        if (currentJavaVersion == null) {
            currentJavaVersion = JavaVersion.toVersion(System.getProperty("java.version"));
        }
        return currentJavaVersion;
    }

    static void resetCurrent() {
        currentJavaVersion = null;
    }

    public static JavaVersion forClassVersion(int classVersion) {
        return JavaVersion.getVersionForMajor(classVersion - 44);
    }

    public static JavaVersion forClass(byte[] classData) {
        if (classData.length < 8) {
            throw new IllegalArgumentException("Invalid class format. Should contain at least 8 bytes");
        }
        return JavaVersion.forClassVersion(classData[7] & 0xFF);
    }

    public boolean isJava5() {
        return this == VERSION_1_5;
    }

    public boolean isJava6() {
        return this == VERSION_1_6;
    }

    public boolean isJava7() {
        return this == VERSION_1_7;
    }

    public boolean isJava8() {
        return this == VERSION_1_8;
    }

    public boolean isJava9() {
        return this == VERSION_1_9;
    }

    public boolean isJava10() {
        return this == VERSION_1_10;
    }

    public boolean isJava11() {
        return this == VERSION_11;
    }

    public boolean isJava12() {
        return this == VERSION_12;
    }

    public boolean isJava5Compatible() {
        return this.isCompatibleWith(VERSION_1_5);
    }

    public boolean isJava6Compatible() {
        return this.isCompatibleWith(VERSION_1_6);
    }

    public boolean isJava7Compatible() {
        return this.isCompatibleWith(VERSION_1_7);
    }

    public boolean isJava8Compatible() {
        return this.isCompatibleWith(VERSION_1_8);
    }

    public boolean isJava9Compatible() {
        return this.isCompatibleWith(VERSION_1_9);
    }

    public boolean isJava10Compatible() {
        return this.isCompatibleWith(VERSION_1_10);
    }

    public boolean isJava11Compatible() {
        return this.isCompatibleWith(VERSION_11);
    }

    public boolean isJava12Compatible() {
        return this.isCompatibleWith(VERSION_12);
    }

    public boolean isCompatibleWith(JavaVersion otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public String toString() {
        return this.versionName;
    }

    public String getMajorVersion() {
        return String.valueOf(this.ordinal() + 1);
    }

    private static JavaVersion getVersionForMajor(int major) {
        return major >= JavaVersion.values().length ? VERSION_HIGHER : JavaVersion.values()[major - 1];
    }
}

