/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;
import org.gradle.plugin.software.internal.ModelDefaultsApplicator;
import org.gradle.plugin.software.internal.SoftwareFeatureApplicator;
import org.gradle.plugin.software.internal.SoftwareTypeImplementation;

public class DefaultSoftwareFeatureApplicator
implements SoftwareFeatureApplicator {
    private final ModelDefaultsApplicator modelDefaultsApplicator;
    private final InspectionScheme inspectionScheme;
    private final InternalProblems problems;
    private final PluginManagerInternal pluginManager;
    private final Set<AppliedFeature> applied = new HashSet<AppliedFeature>();
    private final ClassLoaderScope classLoaderScope;

    public DefaultSoftwareFeatureApplicator(ModelDefaultsApplicator modelDefaultsApplicator, InspectionScheme inspectionScheme, InternalProblems problems, PluginManagerInternal pluginManager, ClassLoaderScope classLoaderScope) {
        this.modelDefaultsApplicator = modelDefaultsApplicator;
        this.inspectionScheme = inspectionScheme;
        this.problems = problems;
        this.pluginManager = pluginManager;
        this.classLoaderScope = classLoaderScope;
    }

    public <T> T applyFeatureTo(ExtensionAware target, SoftwareTypeImplementation<T> softwareFeature) {
        AppliedFeature appliedFeature = new AppliedFeature(target, softwareFeature);
        if (!this.applied.contains(appliedFeature)) {
            this.pluginManager.apply(softwareFeature.getPluginClass());
            Plugin plugin = this.pluginManager.getPluginContainer().getPlugin(softwareFeature.getPluginClass());
            this.applyAndMaybeRegisterExtension(target, softwareFeature, plugin);
            this.applied.add(appliedFeature);
            this.modelDefaultsApplicator.applyDefaultsTo((Object)target, this.classLoaderScope, plugin, softwareFeature);
        }
        return (T)Cast.uncheckedCast((Object)target.getExtensions().getByName(softwareFeature.getSoftwareType()));
    }

    private <T> void applyAndMaybeRegisterExtension(ExtensionAware target, SoftwareTypeImplementation<T> softwareFeature, Plugin<?> plugin) {
        DefaultTypeValidationContext typeValidationContext = DefaultTypeValidationContext.withRootType((Class)softwareFeature.getPluginClass(), (boolean)false, (InternalProblems)this.problems);
        ExtensionAddingVisitor extensionAddingVisitor = new ExtensionAddingVisitor(target, typeValidationContext);
        this.inspectionScheme.getPropertyWalker().visitProperties(plugin, (TypeValidationContext)typeValidationContext, extensionAddingVisitor);
        if (!typeValidationContext.getProblems().isEmpty()) {
            throw new DefaultMultiCauseException(String.format(typeValidationContext.getProblems().size() == 1 ? "A problem was found with the %s plugin." : "Some problems were found with the %s plugin.", DefaultSoftwareFeatureApplicator.getPluginObjectDisplayName(plugin)), (Iterable)typeValidationContext.getProblems().stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
        }
    }

    private static String getPluginObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }

    private static class AppliedFeature {
        private final Object target;
        private final SoftwareTypeImplementation<?> softwareFeature;

        public AppliedFeature(Object target, SoftwareTypeImplementation<?> softwareFeature) {
            this.target = target;
            this.softwareFeature = softwareFeature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppliedFeature that = (AppliedFeature)o;
            return this.target == that.target && Objects.equals(this.softwareFeature, that.softwareFeature);
        }

        public int hashCode() {
            int result = System.identityHashCode(this.target);
            result = 31 * result + this.softwareFeature.hashCode();
            return result;
        }
    }

    @NonNullApi
    public static class ExtensionAddingVisitor<T>
    implements PropertyVisitor {
        private final ExtensionAware target;
        private final DefaultTypeValidationContext validationContext;

        public ExtensionAddingVisitor(ExtensionAware target, DefaultTypeValidationContext validationContext) {
            this.target = target;
            this.validationContext = validationContext;
        }

        public void visitSoftwareTypeProperty(String propertyName, PropertyValue value, Class<?> declaredPropertyType, SoftwareType softwareType) {
            Object publicModelObject = Cast.uncheckedNonnullCast((Object)value.call());
            if (softwareType.disableModelManagement()) {
                Object extension = this.target.getExtensions().findByName(softwareType.name());
                if (extension == null) {
                    this.validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id("extension-not-registered-for-software-type", "was not registered as an extension", GradleCoreProblemGroup.validation().property()).contextualLabel("has @SoftwareType annotation with 'disableModelManagement' set to true, but no extension with name '" + softwareType.name() + "' was registered").severity(Severity.ERROR).details("When 'disableModelManagement' is set, the plugin must register the '" + propertyName + "' property as an extension with the same name as the software type.").solution("During plugin application, register the '" + propertyName + "' property as an extension with the name '" + softwareType.name() + "'.").solution("Set 'disableModelManagement' to false or remove the parameter from the @SoftwareType annotation."));
                } else if (extension != publicModelObject) {
                    this.validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id("mismatched-extension-registered-for-software-type", "does not match the extension registered as '" + softwareType.name(), GradleCoreProblemGroup.validation().property()).contextualLabel("has @SoftwareType annotation with 'disableModelManagement' set to true, but the extension with name '" + softwareType.name() + "' does not match the value of the property").severity(Severity.ERROR).details("When 'disableModelManagement' is set, the plugin must register the '" + propertyName + "' property as an extension with the same name as the software type.").solution("During plugin application, register the '" + propertyName + "' property as an extension with the name '" + softwareType.name() + "'."));
                }
            } else {
                this.target.getExtensions().add(this.publicTypeFrom(softwareType.modelPublicType(), declaredPropertyType), softwareType.name(), publicModelObject);
            }
        }

        private Class<? super T> publicTypeFrom(Class<?> fromAnnotation, Class<?> declaredPropertyType) {
            return (Class)Cast.uncheckedCast(fromAnnotation == Void.class ? declaredPropertyType : fromAnnotation);
        }
    }
}

