/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.internal.StripperSpec;
import org.gradle.nativeplatform.toolchain.internal.AbstractCompiler;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;

public class Stripper
extends AbstractCompiler<StripperSpec> {
    public Stripper(BuildOperationExecutor buildOperationExecutor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, WorkerLeaseService workerLeaseService) {
        super(buildOperationExecutor, commandLineToolInvocationWorker, invocationContext, new StripperArgsTransformer(), false, workerLeaseService);
    }

    @Override
    protected Action<BuildOperationQueue<CommandLineToolInvocation>> newInvocationAction(final StripperSpec spec, List<String> args) {
        final CommandLineToolInvocation invocation = this.newInvocation("Stripping " + spec.getOutputFile().getName(), args, spec.getOperationLogger());
        return new Action<BuildOperationQueue<CommandLineToolInvocation>>(){

            public void execute(BuildOperationQueue<CommandLineToolInvocation> buildQueue) {
                buildQueue.setLogLocation(spec.getOperationLogger().getLogLocation());
                buildQueue.add((BuildOperation)invocation);
            }
        };
    }

    @Override
    protected void addOptionsFileArgs(List<String> args, File tempDir) {
    }

    private static class StripperArgsTransformer
    implements ArgsTransformer<StripperSpec> {
        private StripperArgsTransformer() {
        }

        public List<String> transform(StripperSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(spec.getArgs());
            args.add("-S");
            args.add("-o");
            args.add(spec.getOutputFile().getAbsolutePath());
            args.add(spec.getBinaryFile().getAbsolutePath());
            return args;
        }
    }
}

