/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.NodeIdentifier;

public class ComponentVariantNodeIdentifier
implements NodeIdentifier {
    private final ComponentIdentifier componentId;
    private final String variantName;
    private final int hashCode;

    public ComponentVariantNodeIdentifier(ComponentIdentifier componentId, String variantName) {
        this.componentId = componentId;
        this.variantName = variantName;
        this.hashCode = 31 * componentId.hashCode() + variantName.hashCode();
    }

    public String toString() {
        return this.componentId.getDisplayName() + ":" + this.variantName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentVariantNodeIdentifier that = (ComponentVariantNodeIdentifier)o;
        if (!this.componentId.equals(that.componentId)) {
            return false;
        }
        return this.variantName.equals(that.variantName);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

