/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.api.BuildCancelledException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.Context;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;

public class CancelExecutionStep<C extends Context, R extends Result>
implements Step<C, R> {
    private final BuildCancellationToken cancellationToken;
    private final Step<? super C, ? extends R> delegate;

    public CancelExecutionStep(BuildCancellationToken cancellationToken, Step<? super C, ? extends R> delegate) {
        this.cancellationToken = cancellationToken;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R execute(UnitOfWork work, C context) {
        Thread thread = Thread.currentThread();
        Runnable interrupt = thread::interrupt;
        try {
            this.cancellationToken.addCallback(interrupt);
            R r = this.delegate.execute(work, context);
            return r;
        }
        finally {
            this.cancellationToken.removeCallback(interrupt);
            if (this.cancellationToken.isCancellationRequested()) {
                Thread.interrupted();
                throw new BuildCancelledException("Build cancelled while executing " + work.getDisplayName());
            }
        }
    }
}

