/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.apache.commons.io.FileUtils;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.ImmutableUnitOfWork;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.ImmutableWorkspaceMetadata;
import org.gradle.internal.execution.history.ImmutableWorkspaceMetadataStore;
import org.gradle.internal.execution.history.impl.DefaultExecutionOutputState;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.execution.steps.WorkspaceResult;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignImmutableWorkspaceStep<C extends IdentityContext>
implements Step<C, WorkspaceResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssignImmutableWorkspaceStep.class);
    private final Deleter deleter;
    private final FileSystemAccess fileSystemAccess;
    private final ImmutableWorkspaceMetadataStore workspaceMetadataStore;
    private final OutputSnapshotter outputSnapshotter;
    private final Step<? super PreviousExecutionContext, ? extends CachingResult> delegate;

    public AssignImmutableWorkspaceStep(Deleter deleter, FileSystemAccess fileSystemAccess, ImmutableWorkspaceMetadataStore workspaceMetadataStore, OutputSnapshotter outputSnapshotter, Step<? super PreviousExecutionContext, ? extends CachingResult> delegate) {
        this.deleter = deleter;
        this.fileSystemAccess = fileSystemAccess;
        this.workspaceMetadataStore = workspaceMetadataStore;
        this.outputSnapshotter = outputSnapshotter;
        this.delegate = delegate;
    }

    @Override
    public WorkspaceResult execute(UnitOfWork work, C context) {
        ImmutableWorkspaceProvider workspaceProvider = ((ImmutableUnitOfWork)work).getWorkspaceProvider();
        String uniqueId = ((IdentityContext)context).getIdentity().getUniqueId();
        ImmutableWorkspaceProvider.ImmutableWorkspace workspace = workspaceProvider.getWorkspace(uniqueId);
        return this.loadImmutableWorkspaceIfExists(work, workspace).orElseGet(() -> this.executeInTemporaryWorkspace(work, context, workspace));
    }

    private Optional<WorkspaceResult> loadImmutableWorkspaceIfExists(UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace) {
        File immutableLocation = workspace.getImmutableLocation();
        FileSystemLocationSnapshot workspaceSnapshot = this.fileSystemAccess.read(immutableLocation.getAbsolutePath());
        switch (workspaceSnapshot.getType()) {
            case Directory: {
                return this.loadImmutableWorkspaceIfConsistent(work, workspace);
            }
            case RegularFile: {
                throw new IllegalStateException("Immutable workspace is occupied by a file: " + immutableLocation.getAbsolutePath() + ". Deleting the file in question can allow the content to be recreated.");
            }
            case Missing: {
                return Optional.empty();
            }
        }
        throw new AssertionError();
    }

    private Optional<WorkspaceResult> loadImmutableWorkspaceIfConsistent(UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace) {
        File immutableLocation = workspace.getImmutableLocation();
        ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots = this.outputSnapshotter.snapshotOutputs(work, immutableLocation);
        ImmutableListMultimap<String, HashCode> outputHashes = AssignImmutableWorkspaceStep.calculateOutputHashes(outputSnapshots);
        ImmutableWorkspaceMetadata metadata = this.workspaceMetadataStore.loadWorkspaceMetadata(immutableLocation);
        if (!metadata.getOutputPropertyHashes().equals(outputHashes)) {
            return workspace.withTemporaryWorkspace(temporaryWorkspace -> {
                this.moveInconsistentImmutableWorkspaceToTemporaryLocation(immutableLocation, temporaryWorkspace, outputSnapshots);
                return Optional.empty();
            });
        }
        return Optional.of(AssignImmutableWorkspaceStep.loadImmutableWorkspace(work, immutableLocation, metadata, outputSnapshots));
    }

    private static WorkspaceResult loadImmutableWorkspace(UnitOfWork work, File immutableLocation, ImmutableWorkspaceMetadata metadata, ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots) {
        OriginMetadata originMetadata = metadata.getOriginMetadata();
        DefaultExecutionOutputState afterExecutionOutputState = new DefaultExecutionOutputState(true, outputSnapshots, originMetadata, true);
        return new WorkspaceResult(CachingResult.shortcutResult(Duration.ZERO, ExecutionEngine.Execution.skipped(ExecutionEngine.ExecutionOutcome.UP_TO_DATE, work), afterExecutionOutputState, null, originMetadata), immutableLocation);
    }

    private void moveInconsistentImmutableWorkspaceToTemporaryLocation(File immutableLocation, File failedWorkspaceLocation, ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots) {
        this.fileSystemAccess.invalidate((Iterable)ImmutableList.of((Object)immutableLocation.getAbsolutePath()));
        String outputHashes = outputSnapshots.entrySet().stream().map(entry -> (String)entry.getKey() + ":\n" + ((FileSystemSnapshot)entry.getValue()).roots().map(AssignImmutableWorkspaceStep::describeSnapshot).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"));
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)String.format("The contents of the immutable workspace '%s' have been modified.", immutableLocation.getAbsolutePath())).withContext("These workspace directories are not supposed to be modified once they are created. The modification might have been caused by an external process, or could be the result of disk corruption. " + String.format("The inconsistent workspace will be moved to '%s', and will be recreated.", failedWorkspaceLocation.getAbsolutePath()) + "\n" + outputHashes)).willBecomeAnErrorInGradle9().undocumented()).nagUser();
        try {
            Files.move(immutableLocation.toPath(), failedWorkspaceLocation.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not move inconsistent immutable workspace (%s) to temporary location (%s)", immutableLocation.getAbsolutePath(), failedWorkspaceLocation.getAbsolutePath()), e);
        }
    }

    private WorkspaceResult executeInTemporaryWorkspace(UnitOfWork work, C context, ImmutableWorkspaceProvider.ImmutableWorkspace workspace) {
        return workspace.withTemporaryWorkspace(temporaryWorkspace -> {
            WorkspaceContext workspaceContext = new WorkspaceContext((IdentityContext)context, temporaryWorkspace, null, true);
            this.fileSystemAccess.invalidate((Iterable)ImmutableList.of((Object)temporaryWorkspace.getAbsolutePath()));
            PreviousExecutionContext previousExecutionContext = new PreviousExecutionContext(workspaceContext, null);
            CachingResult delegateResult = this.delegate.execute(work, previousExecutionContext);
            if (delegateResult.getExecution().isSuccessful()) {
                ExecutionOutputState executionOutputState = delegateResult.getAfterExecutionOutputState().get();
                ImmutableListMultimap<String, HashCode> outputHashes = AssignImmutableWorkspaceStep.calculateOutputHashes(executionOutputState.getOutputFilesProducedByWork());
                ImmutableWorkspaceMetadata metadata = new ImmutableWorkspaceMetadata(executionOutputState.getOriginMetadata(), outputHashes);
                this.workspaceMetadataStore.storeWorkspaceMetadata(temporaryWorkspace, metadata);
                return this.moveTemporaryWorkspaceToImmutableLocation(workspace, new WorkspaceMoveHandler(work, workspace, temporaryWorkspace, delegateResult));
            }
            return new WorkspaceResult(delegateResult, null);
        });
    }

    private static ImmutableListMultimap<String, HashCode> calculateOutputHashes(ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots) {
        return (ImmutableListMultimap)outputSnapshots.entrySet().stream().flatMap(entry -> ((FileSystemSnapshot)entry.getValue()).roots().map(locationSnapshot -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)locationSnapshot.getHash()))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private WorkspaceResult moveTemporaryWorkspaceToImmutableLocation(ImmutableWorkspaceProvider.ImmutableWorkspace workspace, WorkspaceMoveHandler move) {
        return move.executeMoveOr(moveFailedException -> {
            LOGGER.debug("Could not move temporary workspace ({}) to immutable location ({}), attempting copy-then-move", new Object[]{move.temporaryWorkspace.getAbsolutePath(), workspace.getImmutableLocation().getAbsolutePath(), moveFailedException});
            return workspace.withTemporaryWorkspace(secondaryTemporaryWorkspace -> {
                WorkspaceResult result = move.duplicateTemporaryWorkspaceTo(secondaryTemporaryWorkspace).executeMoveOrThrow();
                move.removeTemporaryWorkspace();
                return result;
            });
        });
    }

    private static String describeSnapshot(FileSystemLocationSnapshot root) {
        final StringBuilder builder = new StringBuilder();
        root.accept(new FileSystemSnapshotHierarchyVisitor(){
            private int indent = 0;

            public void enterDirectory(DirectorySnapshot directorySnapshot) {
                ++this.indent;
            }

            public void leaveDirectory(DirectorySnapshot directorySnapshot) {
                --this.indent;
            }

            public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
                for (int i = 0; i < this.indent; ++i) {
                    builder.append("  ");
                }
                builder.append(" - ");
                builder.append(snapshot.getName());
                builder.append(" (");
                builder.append(snapshot.getType());
                builder.append(", ");
                builder.append(snapshot.getHash());
                builder.append(")");
                builder.append("\n");
                return SnapshotVisitResult.CONTINUE;
            }
        });
        return builder.toString();
    }

    private class WorkspaceMoveHandler {
        private final UnitOfWork work;
        private final ImmutableWorkspaceProvider.ImmutableWorkspace workspace;
        private final File temporaryWorkspace;
        private final CachingResult delegateResult;

        public WorkspaceMoveHandler(UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace, File temporaryWorkspace, CachingResult delegateResult) {
            this.work = work;
            this.workspace = workspace;
            this.temporaryWorkspace = temporaryWorkspace;
            this.delegateResult = delegateResult;
        }

        public WorkspaceResult executeMoveOr(Function<FileSystemException, WorkspaceResult> failedMoveHandler) {
            File immutableLocation = this.workspace.getImmutableLocation();
            try {
                AssignImmutableWorkspaceStep.this.fileSystemAccess.moveAtomically(this.temporaryWorkspace.getAbsolutePath(), immutableLocation.getAbsolutePath());
                return new WorkspaceResult(this.delegateResult, immutableLocation);
            }
            catch (FileSystemException moveWorkspaceException) {
                if (immutableLocation.isDirectory()) {
                    LOGGER.debug("Could not move temporary workspace ({}) to immutable location ({}), assuming it was moved in place concurrently", new Object[]{this.temporaryWorkspace.getAbsolutePath(), immutableLocation.getAbsolutePath(), moveWorkspaceException});
                    return AssignImmutableWorkspaceStep.this.loadImmutableWorkspaceIfConsistent(this.work, this.workspace).map(result -> {
                        this.removeTemporaryWorkspace();
                        return result;
                    }).orElseGet(this::executeMoveOrThrow);
                }
                return failedMoveHandler.apply(moveWorkspaceException);
            }
            catch (IOException e) {
                throw this.unableToMoveBecause(e);
            }
        }

        public WorkspaceResult executeMoveOrThrow() {
            return this.executeMoveOr(moveFailedException -> {
                throw this.unableToMoveBecause((IOException)moveFailedException);
            });
        }

        public WorkspaceMoveHandler duplicateTemporaryWorkspaceTo(File duplicateTemporaryWorkspace) {
            try {
                FileUtils.copyDirectory((File)this.temporaryWorkspace, (File)duplicateTemporaryWorkspace, file -> true, (boolean)true, (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
            }
            catch (IOException duplicateCopyException) {
                throw new UncheckedIOException(String.format("Could not make copy of temporary workspace (%s) to (%s)", this.temporaryWorkspace.getAbsolutePath(), duplicateTemporaryWorkspace.getAbsolutePath()), duplicateCopyException);
            }
            return new WorkspaceMoveHandler(this.work, this.workspace, duplicateTemporaryWorkspace, this.delegateResult);
        }

        private void removeTemporaryWorkspace() {
            try {
                AssignImmutableWorkspaceStep.this.deleter.deleteRecursively(this.temporaryWorkspace);
            }
            catch (IOException removeTempException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not remove temporary workspace: {}", (Object)this.temporaryWorkspace.getAbsolutePath(), (Object)removeTempException);
                }
                LOGGER.info("Could not remove temporary workspace: {}: {}", (Object)this.temporaryWorkspace.getAbsolutePath(), (Object)removeTempException.getMessage());
            }
        }

        @CheckReturnValue
        private UncheckedIOException unableToMoveBecause(IOException cause) {
            return new UncheckedIOException(String.format("Could not move temporary workspace (%s) to immutable location (%s)", this.temporaryWorkspace.getAbsolutePath(), this.workspace.getImmutableLocation().getAbsolutePath()), cause);
        }
    }
}

