/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSuperClass", "isEitherModuleOrNonModule", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsModuleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsModuleChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n295#2,2:61\n*S KotlinDebug\n*F\n+ 1 FirJsModuleChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker\n*L\n51#1:61,2\n*E\n"})
public final class FirJsModuleChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsModuleChecker INSTANCE = new FirJsModuleChecker();

    private FirJsModuleChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkSuperClass(declaration, context, reporter);
        if (declaration instanceof FirFile || !this.isEitherModuleOrNonModule(declaration, context.getSession())) {
            return;
        }
        if (declaration instanceof FirProperty && ((FirProperty)declaration).isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirProperty)declaration).getSource(), FirJsErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_VAR(), (DiagnosticContext)context, null, 8, null);
        }
        if ((object = FirHelpersKt.closestNonLocalWith(context, declaration)) == null || (object = ((FirDeclaration)object).getSymbol()) == null) {
            return;
        }
        Object closestNonLocal = object;
        if (!FirJsHelpersKt.isNativeObject(closestNonLocal, context)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_NON_NATIVE(), (DiagnosticContext)context, null, 8, null);
        }
        if (FirHelpersKt.isTopLevel(context)) {
            FirFile firFile = context.getContainingFile();
            boolean bl = firFile != null ? this.isEitherModuleOrNonModule(firFile, context.getSession()) : false;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNESTED_JS_MODULE_PROHIBITED(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final void checkSuperClass(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter) {
        Object v3;
        Object superClassSymbol;
        block4: {
            FirClass firClass = declaration instanceof FirClass ? (FirClass)declaration : null;
            if (firClass == null) {
                return;
            }
            FirClass classDeclaration = firClass;
            Object object = FirJsHelpersKt.superClassNotAny(classDeclaration, context.getSession());
            if (object == null || (object = TypeUtilsKt.toSymbol((ConeClassLikeType)object, context.getSession())) == null) {
                return;
            }
            superClassSymbol = object;
            Iterable $this$firstOrNull$iv = classDeclaration.getSuperTypeRefs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirTypeRef it = (FirTypeRef)element$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(it);
                if (!Intrinsics.areEqual(coneKotlinType != null ? TypeUtilsKt.toSymbol(coneKotlinType, context.getSession()) : null, (Object)superClassSymbol)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        FirTypeRef superClassRef = v3;
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)superClassSymbol;
        Object object = superClassRef;
        if (object == null || (object = ((FirTypeRef)object).getSource()) == null) {
            object = ((FirClass)declaration).getSource();
        }
        FirJsModuleCheckUtilsKt.checkJsModuleUsage(firBasedSymbol, context, reporter, (AbstractKtSourceElement)object);
    }

    private final boolean isEitherModuleOrNonModule(FirDeclaration $this$isEitherModuleOrNonModule, FirSession session2) {
        return FirAnnotationUtilsKt.hasAnnotation($this$isEitherModuleOrNonModule, JsStandardClassIds.Annotations.JsModule, session2) || FirAnnotationUtilsKt.hasAnnotation($this$isEitherModuleOrNonModule, JsStandardClassIds.Annotations.JsNonModule, session2);
    }
}

