/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;

@ApiStatus.NonExtendable
public abstract class VolatileNullableLazyValue<T>
extends NullableLazyValue<T> {
    private volatile boolean myComputed;
    @Nullable
    private volatile T myValue;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    VolatileNullableLazyValue() {
    }

    @Override
    @Nullable
    public T getValue() {
        boolean computed = this.myComputed;
        T value2 = this.myValue;
        if (!computed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value2;
                this.myComputed = true;
            }
        }
        return value2;
    }
}

