/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.workers.internal.FilteringClassLoaderSpecSerializer;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;
import org.gradle.workers.internal.VisitableURLClassLoaderSpecSerializer;

public class HierarchicalClassLoaderStructureSerializer
implements Serializer<HierarchicalClassLoaderStructure> {
    private static final byte ROOT = 0;
    private static final byte HAS_PARENT = 1;
    private static final byte FILTERING_SPEC = 0;
    private static final byte VISITABLE_URL_CLASSLOADER_SPEC = 1;
    private final FilteringClassLoaderSpecSerializer filteringClassLoaderSpecSerializer = new FilteringClassLoaderSpecSerializer();
    private final VisitableURLClassLoaderSpecSerializer visitableURLClassLoaderSpecSerializer = new VisitableURLClassLoaderSpecSerializer();

    public void write(Encoder encoder, HierarchicalClassLoaderStructure classLoaderStructure) throws Exception {
        if (classLoaderStructure.getParent() == null) {
            encoder.writeByte((byte)0);
        } else {
            encoder.writeByte((byte)1);
            this.write(encoder, classLoaderStructure.getParent());
        }
        if (classLoaderStructure.getSpec() instanceof FilteringClassLoader.Spec) {
            encoder.writeByte((byte)0);
            this.filteringClassLoaderSpecSerializer.write(encoder, (FilteringClassLoader.Spec)classLoaderStructure.getSpec());
        } else if (classLoaderStructure.getSpec() instanceof VisitableURLClassLoader.Spec) {
            encoder.writeByte((byte)1);
            this.visitableURLClassLoaderSpecSerializer.write(encoder, (VisitableURLClassLoader.Spec)classLoaderStructure.getSpec());
        }
    }

    public HierarchicalClassLoaderStructure read(Decoder decoder) throws Exception {
        FilteringClassLoader.Spec spec;
        HierarchicalClassLoaderStructure parent;
        byte parentTag = decoder.readByte();
        switch (parentTag) {
            case 0: {
                parent = null;
                break;
            }
            case 1: {
                parent = this.read(decoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected payload type.");
            }
        }
        byte specTag = decoder.readByte();
        switch (specTag) {
            case 0: {
                spec = this.filteringClassLoaderSpecSerializer.read(decoder);
                break;
            }
            case 1: {
                spec = this.visitableURLClassLoaderSpecSerializer.read(decoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected payload type.");
            }
        }
        return new HierarchicalClassLoaderStructure((ClassLoaderSpec)spec, parent);
    }
}

