/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.logging.text.TreeFormatter;

public class FilteredFileTree
extends CompositeFileTree
implements FileCollectionInternal.Source {
    private final FileTreeInternal tree;
    private final Supplier<? extends PatternSet> patternSupplier;

    public FilteredFileTree(FileTreeInternal tree, TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory, Supplier<? extends PatternSet> patternSupplier) {
        super(taskDependencyFactory, patternSetFactory);
        this.tree = tree;
        this.patternSupplier = patternSupplier;
    }

    @Override
    public String getDisplayName() {
        return this.tree.getDisplayName();
    }

    @Override
    protected void appendContents(TreeFormatter formatter) {
        formatter.node("backing tree");
        formatter.startChildren();
        this.tree.describeContents(formatter);
        formatter.endChildren();
    }

    public FileTreeInternal getTree() {
        return this.tree;
    }

    public PatternSet getPatterns() {
        return this.patternSupplier.get();
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        PatternSet patterns = this.getPatterns();
        this.tree.visitContentsAsFileTrees(arg_0 -> FilteredFileTree.lambda$visitChildren$0(visitor, (PatternFilterable)patterns, arg_0));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.tree.visitDependencies(context);
    }

    private static /* synthetic */ void lambda$visitChildren$0(Consumer visitor, PatternFilterable patterns, FileTreeInternal child) {
        visitor.accept(child.matching(patterns));
    }
}

