/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.nio.file.Path;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.util.internal.GUtil;

public class BaseDirFileResolver
extends AbstractFileResolver {
    private final File baseDir;

    public BaseDirFileResolver(File baseDir) {
        if (!GUtil.isTrue((Object)baseDir)) {
            throw new IllegalArgumentException(String.format("baseDir may not be null or empty string. basedir='%s'", baseDir));
        }
        if (!baseDir.isAbsolute()) {
            throw new IllegalArgumentException(String.format("base dir '%s' is not an absolute file.", baseDir));
        }
        this.baseDir = baseDir;
    }

    public String resolveAsRelativePath(Object path) {
        Path baseDir = this.baseDir.toPath();
        Path file = this.resolve(path).toPath();
        if (file.equals(baseDir)) {
            return ".";
        }
        return baseDir.relativize(file).toString();
    }

    @Override
    public String resolveForDisplay(Object path) {
        Path baseDir;
        Path file = this.resolve(path).toPath();
        if (file.equals(baseDir = this.baseDir.toPath())) {
            return ".";
        }
        Path parent = baseDir.getParent();
        if (parent == null) {
            parent = baseDir;
        }
        if (file.startsWith(parent)) {
            return baseDir.relativize(file).toString();
        }
        return file.toString();
    }

    @Override
    protected File doResolve(File file) {
        if (!file.isAbsolute()) {
            return new File(this.baseDir, file.getPath());
        }
        return file;
    }

    public boolean canResolveRelativePath() {
        return true;
    }
}

