/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.SVGBridgeExtension;
import io.sf.carte.echosvg.bridge.svg12.BindableElementBridge;
import io.sf.carte.echosvg.bridge.svg12.SVG12TextElementBridge;
import io.sf.carte.echosvg.bridge.svg12.SVGFlowRootElementBridge;
import io.sf.carte.echosvg.bridge.svg12.SVGMultiImageElementBridge;
import io.sf.carte.echosvg.bridge.svg12.SVGSolidColorElementBridge;
import io.sf.carte.echosvg.bridge.svg12.XBLContentElementBridge;
import io.sf.carte.echosvg.bridge.svg12.XBLShadowTreeElementBridge;
import org.w3c.dom.Element;

public class SVG12BridgeExtension
extends SVGBridgeExtension {
    @Override
    public float getPriority() {
        return 0.0f;
    }

    @Override
    public String getAuthor() {
        return "The Apache Batik Team.";
    }

    @Override
    public String getContactAddress() {
        return "batik-dev@xmlgraphics.apache.org";
    }

    @Override
    public String getURL() {
        return "http://xml.apache.org/batik";
    }

    @Override
    public String getDescription() {
        return "The required SVG 1.2 tags";
    }

    @Override
    public void registerTags(BridgeContext bridgeContext) {
        super.registerTags(bridgeContext);
        bridgeContext.putBridge(new SVGFlowRootElementBridge());
        bridgeContext.putBridge(new SVGMultiImageElementBridge());
        bridgeContext.putBridge(new SVGSolidColorElementBridge());
        bridgeContext.putBridge(new SVG12TextElementBridge());
        bridgeContext.putBridge(new XBLShadowTreeElementBridge());
        bridgeContext.putBridge(new XBLContentElementBridge());
        bridgeContext.setDefaultBridge(new BindableElementBridge());
        bridgeContext.putReservedNamespaceURI(null);
        bridgeContext.putReservedNamespaceURI("http://www.w3.org/2000/svg");
        bridgeContext.putReservedNamespaceURI("http://www.w3.org/2004/xbl");
    }

    @Override
    public boolean isDynamicElement(Element element) {
        String string = element.getNamespaceURI();
        if ("http://www.w3.org/2004/xbl".equals(string)) {
            return true;
        }
        if (!"http://www.w3.org/2000/svg".equals(string)) {
            return false;
        }
        String string2 = element.getLocalName();
        return string2.equals("script") || string2.equals("handler") || string2.startsWith("animate") || string2.equals("set");
    }
}

