/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.GeneratorExpressionLoop;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.Scope;

public class GeneratorExpression
extends Scope {
    private AstNode result;
    private List<GeneratorExpressionLoop> loops = new ArrayList<GeneratorExpressionLoop>();
    private AstNode filter;
    private int ifPosition = -1;
    private int lp = -1;
    private int rp = -1;

    public GeneratorExpression() {
        this.type = 166;
    }

    public GeneratorExpression(int n) {
        super(n);
        this.type = 166;
    }

    public GeneratorExpression(int n, int n2) {
        super(n, n2);
        this.type = 166;
    }

    public AstNode getResult() {
        return this.result;
    }

    public void setResult(AstNode astNode) {
        this.assertNotNull(astNode);
        this.result = astNode;
        astNode.setParent(this);
    }

    public List<GeneratorExpressionLoop> getLoops() {
        return this.loops;
    }

    public void setLoops(List<GeneratorExpressionLoop> list) {
        this.assertNotNull(list);
        this.loops.clear();
        for (GeneratorExpressionLoop generatorExpressionLoop : list) {
            this.addLoop(generatorExpressionLoop);
        }
    }

    public void addLoop(GeneratorExpressionLoop generatorExpressionLoop) {
        this.assertNotNull(generatorExpressionLoop);
        this.loops.add(generatorExpressionLoop);
        generatorExpressionLoop.setParent(this);
    }

    public AstNode getFilter() {
        return this.filter;
    }

    public void setFilter(AstNode astNode) {
        this.filter = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public int getIfPosition() {
        return this.ifPosition;
    }

    public void setIfPosition(int n) {
        this.ifPosition = n;
    }

    public int getFilterLp() {
        return this.lp;
    }

    public void setFilterLp(int n) {
        this.lp = n;
    }

    public int getFilterRp() {
        return this.rp;
    }

    public void setFilterRp(int n) {
        this.rp = n;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("(");
        stringBuilder.append(this.result.toSource(0));
        for (GeneratorExpressionLoop generatorExpressionLoop : this.loops) {
            stringBuilder.append(generatorExpressionLoop.toSource(0));
        }
        if (this.filter != null) {
            stringBuilder.append(" if (");
            stringBuilder.append(this.filter.toSource(0));
            stringBuilder.append(")");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (!nodeVisitor.visit(this)) {
            return;
        }
        this.result.visit(nodeVisitor);
        for (GeneratorExpressionLoop generatorExpressionLoop : this.loops) {
            generatorExpressionLoop.visit(nodeVisitor);
        }
        if (this.filter != null) {
            this.filter.visit(nodeVisitor);
        }
    }
}

